function es_ricker()
    % Dati del problema
    x0 = 1000;
    r = 3.0; % Per r <= 1: convergenza ad uno stato stabile, senza oscillare
             % Per 1 < r < 2: convergenza con oscillazioni
             % Per 2 <= r <= 2.5: comportamento periodico
             % Per r > 2.5: comportamento caotico
    N = 2000;

    % Simulazione
    X = [];
    T = 1:100; % Istanti di tempo
    xc = x0; % Stato iniziale
    for t = T
        X(t) = xc; % Salvo lo stato corrente
        xc = f(xc, r, N); % Genero lo stato futuro
    end

    % Disegno l'andamento nel tempo
    plot(T, X)
end


function xf = f(x, r, N)
    xf = x * exp(r * (1 - x/N));
end
