function es_cumprod()
    % Carico i dati
    V = rand(1, 6);

    % Calcolo i prodotti cumulativi
    z1 = my_cumprod(V);

    % Ripeto l'operazione utilizzando la funzione di Octave
    z2 = cumprod(V);

    % Verifico che il risultato sia corretto
    all(z1 == z2)
end

function z = my_cumprod(V)
	n = length(V);
	z(1) = V(1);
	for ii = 2:n
		z(ii) = z(ii-1) * V(ii);
	end
end