function beverton_holt()
    % Configurazione
    x0 = 500;
    r = 1.6; % r deve essere nell'intervallo [1.0, 2.0]
             % Per r  1.5 la popolazione resta costante
             % Per r < 1.5 la popolazione cala (anche drasticamente)
             % Per r > 1.5 la popolazione si stabilizza
    N = 1000;

    % Simulazione
    T = 1:100;
    xc = x0;
    for t = T
        x(t) = xc;
        xc = f(xc, r, N);
    end

    % Disegno l'andamento nel tempo
    plot(T, x);
end

function xf = f(x, r, N)
    xf = r * x / (1 + x/N);
end
