function es_lotka_volterra()
    a = 0.2; % Tasso di crescita della popolazione di conigli
    b = 0.0006; % Tasso di predazione
    d = 0.00004; % Bonus riproduttivo per predazione
    g = 0.1; % Tasso di calo della popolazione di volpi

    nr0 = 2000;
    nf0 = 200;
    nr1 = 2500;
    nf1 = 400;
    
    % =========================================================================
    % Q2: Determino l'andamento delle due popolazioni
    % =========================================================================

    dX = @(t, x) lotka_volterra(x, a, b, d, g)';
    tspan = [0, 12 * 10];
    x0 = [nr0, nf0];
    [t, X] = ode45(dX, tspan, x0);
    nr = X(:, 1);
    nf = X(:, 2);

    % Disegno l'andamento delle due popolazioni
    figure();
    plot(t, nr, 'linewidth', 2);
    hold on
    plot(t, nf, 'linewidth', 2);
    hold off
    grid();
    xlabel('Tempo (mesi)', 'fontsize', 14);

    % Disegno la traiettoria nello spazio degli stati/spazio delle fasi
    figure();
    plot(nr, nf, 'linewidth', 2);
    grid();
    xlabel('Numero di conigli', 'fontsize', 14);
    ylabel('Numero di volpi', 'fontsize', 14);
    title('Traiettoria nello spazio delle fasi', 'fontsize', 14);

    % =========================================================================
    % Q1: determino il secondo punto di equilibrio
    % =========================================================================

    % NOTA: la funzione lotka_volterra calcola gia' la derivata dello stato
    fz = @(x) lotka_volterra(x, a, b, d, g);
    [xeq, fval, flag] = fsolve(fz, [nr0, nf0]);
    nr = xeq(1);
    nf = xeq(2);

    fprintf('Stato di equilibrio\n');
    fprintf('Numero conigli: %.2f, Numero di volpi: %.2f\n', nr, nf);

    % ==========================================================================
    % Q3: Determino i valori di b e d perché le due popolazioni abbiano
    % all'equilibrio i valori desiderati
    % ==========================================================================

    % NOTA: uso la funzione lotka_volterra per definire un nuovo sistema
    % Convenzione: y(1) = b, y(2) = d
    fz2 = @(y) lotka_volterra([nr1, nf1], a, y(1), y(2), g);
    [yeq, fval2, flag2] = fsolve(fz2, [nr0, nf0])
    b_sol = yeq(1)
    d_sol = yeq(2)

    % ==========================================================================
    % Q4: Implemento il metodo RK 3/8 e risolvo di nuovo l'ODE
    % ==========================================================================

    X2 = my_RK38(dX, t, x0);
    nr2 = X2(:, 1);

    % Confronto l'andamento delle popolazioni di conigli nelle due soluzioni
    figure();
    plot(t, nr, 'linewidth', 2);
    hold on
    plot(t, nr2, 'linewidth', 2);
    hold off
    grid();
    xlabel('Tempo', 'fontsize', 14);
end

function X = my_RK38(f, Ti, x0)
    X(:, 1) = x0;
    for i = 2:length(Ti)
        h = Ti(i)-Ti(i-1);
        % Calcolo le posizioni dei "nodi"
        % NOTA: qui uso i coefficienti a sx della riga verticale del tableau
        n1 = Ti(i-1);
        n2 = Ti(i-1) + h * 1/3;
        n3 = Ti(i-1) + h * 2/3;
        n4 = Ti(i-1) + h * 1;
        % Calcolo le stime intermedie
        % NOTA: qui uso i coefficienti a dx della riga verticale del tableau
        k1 = f(n1, X(:, i-1));
        k2 = f(n2, X(:, i-1) + h * (1/3*k1) );
        k3 = f(n3, X(:, i-1) + h * (-1/3*k1 +1*k2) );
        k4 = f(n4, X(:, i-1) + h * (1*k1 -1*k2 +1*k3) );
        % Calcolo la stima finale
        % NOTA: qui uso i coefficienti nell'ultima riga del tableau
        X(:, i) = X(:, i-1) + h * (1/8*k1 + 3/8*k2 + 3/8*k3 + 1/8*k4);
    end
    X = X'; % Traspongo la matrice degli stati
end

function dx = lotka_volterra(x, a, b, d, g)
    % x(1) = numero di conigli, x(2) = numero di volpi
    dx(1) = a .* x(1) - b .* x(1) .* x(2);
    dx(2) = d .* x(1) .* x(2) - g .* x(2);
end
