#include <fcntl.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <time.h>
#include <unistd.h>

#define N 10
#define MAX_STRLEN 256
#define INTERVAL 3

void play_lottery(int p, int fdin, int fdout);
void coord_lottery(int k, int p, int pp[][2], char inPath[], int fdout);

int main(int argc, char **argv)
{
	int i, fdin, fdout, pp[N][2], k, p;
	char *endptr = NULL;
	if (argc != 5) {
		fprintf(stderr, "Numero di argomenti errato\n");
		exit(EXIT_FAILURE);
	}

	if ((fdin = open(argv[3], O_RDONLY)) < 0) {
		perror("Impossibile aprire il file di input");
		exit(EXIT_FAILURE);
	}

	/* Creo il file di output, sovrascrivendo il contenuto precedente
	 * (O_TRUNC); L'io pointer del file di uscita sarà condiviso tra i 
	 * vari processi per garantire che ognuno scriva sempre alla fine
	 * del file già aperto
	 */
	if ((fdout = open(argv[4], O_RDWR | O_CREAT | O_TRUNC, 0755)) < 0) {
		perror("Impossibile aprire o creare il file di output");
		exit(EXIT_FAILURE);
	}

	/* strtol, simile ad aoi, ma permette di controllare eventuali erroi */
	k = strtol(argv[1], &endptr, 10);
	if (*endptr != '\0' || k <= 0 || k > N) {
		fprintf(stderr,
			"Il primo argomento non è un intero positivo valido\n");
		exit(EXIT_FAILURE);
	}

	p = strtol(argv[2], &endptr, 10);
	if (*endptr != '\0' || p <= 0) {
		fprintf(stderr,
			"Il secondo argomento non è un intero positivo valido\n");
		exit(EXIT_FAILURE);
	}

	/* Creo le k pipe e i k partecipanti */
	for (i = 0; i < k; i++) {
		int pid;
		if (pipe(pp[i]) < 0) {
			perror("Impossibile creare la pipe");
			/*  termino tutti i processi */
			kill(0, SIGTERM);
		}
		printf("pid %d, pipe %d: %d %d\n", getpid(), i, pp[i][0],
		       pp[i][1]);

		pid = fork();
		if (pid > 0) {
			printf("%d\n", getpid());
			close(pp[i][0]);
		} else if (pid == 0) {
			int j = 0;
			/* chiudo TUTTE le pipe che non servono. Particolare
			 * attenzione va data alla chiusura dei lati di scrittura
			 * per evitare che lettori possano restare bloccati su
			 * una read
			 */
			for (; j <= i; j++) {
				close(pp[j][1]);
			}
			/*I/O pointer condiviso sia per fdin che per fdout. Leggendo da
			 * fdin con I/O pointer condiviso riesco a far si che ogni
			 * figlio legga un intero diverso da quello letto dagli
			 * altri partecipanti. Inoltre l'ordine in cui i processi
			 * accederanno al file dipenderà dall'ordine di scheduling
			 * dei processi che, in generale, è casuale
			 */
			play_lottery(pp[i][0], fdin, fdout);
			exit(EXIT_SUCCESS);

		} else {
			perror("Impossibile creare il processo");
			/* termino tutti i processi */
			kill(0, SIGTERM);
		}
	}
	for (i = 0; i < k; i++) {
		close(pp[i][0]);
	}

	/* Non voglio che il processo padre condivida con i figlio l'io
	 * pointer del file di input*/
	close(fdin);
	coord_lottery(k, p, pp, argv[3], fdout);

	/* Aspetto che i k partecipanti terminino (_ho già chiuso tutte le pipe_)*/
	for (i = 0; i < k; i++) {
		wait(NULL);
	}

	return EXIT_SUCCESS;
}

void play_lottery(int p, int fdin, int fdout)
{
	int winner, mynum, n, i = 0;
	char buff[MAX_STRLEN];

	/* Scelgo il mio biglietto dal file di ingresso: la condivisione
	 * dell'io pointer e la concorrenza delle letture avranno l'effetto
	 * collaterale di far si che il biglietto scelto sia casuale
	 */
	if (read(fdin, &mynum, sizeof(int)) < 0) {
		perror("Impossible scegliere il numero di serie");
		exit(EXIT_FAILURE);
	}
	close(fdin);

	while ((n = read(p, &winner, sizeof(int))) > 0) {
		printf("Partecipante %d, ricevuto il numero %d\n", getpid(),
		       winner);
		if (winner == mynum) {
			printf("Partecipante %d. Ho vinto l'estrazione %d\n",
			       getpid(), i);
			sprintf(buff,
				"Partecipante con pid %d, e ho vinto l'estrazione %d grazie al biglietto %d\n",
				getpid(), i, winner);
			write(fdout, buff, strlen(buff));
		}
		i++;
	}
	if (n < 0) {
		perror("Errore nella lettura dalla pipe");
		exit(EXIT_FAILURE);
	}
	close(fdout);
	close(p);
}

void coord_lottery(int k, int p, int pp[][2], char inPath[], int fdout)
{
	int i = 0, j, winner, fd, numbers[N];
	char buff[MAX_STRLEN];

	/* Leggo i k numeri dal file di input */
	if ((fd = open(inPath, O_RDONLY)) < 0) {
		perror("Impossibile leggere dal file di input");
		kill(0, SIGTERM);
	}

	if (read(fd, numbers, k * sizeof(int)) != k * sizeof(int)) {
		fprintf(stderr,
			"Impossibile leggere tutti i k numeri dal file\n");
		kill(0, SIGTERM);
	}

	printf("Coordinatore %d: inizio con la lotteria con %d estrazioni...\n",
	       getpid(), p);
	/* Inizializzo il generatore di numeri casuali */
	srand(getpid() * time(NULL));
	for (i = 0; i < p; i++) {
		winner = numbers[rand() % k];
		printf("Coordinatore: estratto il numero %d\n", winner);
		/* comunico a tutti il vincitore */
		for (j = 0; j < k; j++) {
			printf("P0 scrivo a %d\n", j);
			if (write(pp[j][1], &winner, sizeof(int)) < 0) {
				perror("Warning:errore nella write");
				kill(0, SIGTERM);
			}
		}
		sleep(INTERVAL);
	}

	sprintf(buff, "Fine delle estrazioni\n");
	write(fdout, buff, strlen(buff));
	close(fdout);

	for (i = 0; i < k; i++) {
		close(pp[i][1]);
	}

}
