//
//  monitor.java
//  

import java.util.concurrent.locks.*;

public class monitor
{ //Dati:
private  int N; //costante che esprime il numero di calzolai
private final int MAX=100;
private final int mis1=0; //misura 1
private final int mis2=1; //misura 2
private final int dx=0;
private final int sn=1;
private int[] scarpe_mis1=new int[2]; //scarpe misura 1
private int[] scarpe_mis2=new int[2]; ; //scarpe misura 2

private Lock lock= new ReentrantLock();
private Condition []coda_mis1=new Condition[2];
private Condition []coda_mis2=new Condition[2];
private Condition codaOP=lock.newCondition();
private int sospOP;
private int[] sosp_mis1=new int[2]; //scarpe misura 1
private int[] sosp_mis2=new int[2]; //scarpe misura 2



//Costruttore:
public monitor() 
{
	int i;
	for(i=0; i<2; i++)
	{	coda_mis1[i]=lock.newCondition(); 
		coda_mis2[i]=lock.newCondition(); 
		scarpe_mis1[i]=0;
		scarpe_mis1[i]=0;
		sosp_mis1[i]=0;
		sosp_mis1[i]=0;
	}
	sospOP=0;
}


private boolean pronto(int misura)
{	boolean ris=false;
	if (misura==mis1) 
	{	if ((scarpe_mis1[dx]>0) && (scarpe_mis1[sn]>0))
				ris=true;
	}
	else
	{	if ((scarpe_mis2[dx]>0) && (scarpe_mis2[sn]>0))
				ris=true;
	}
	return ris;
}


//metodi "entry":

public void prelievo() throws InterruptedException
{	lock.lock();
	try
  {		while	   (! pronto(mis1) && ! pronto(mis2) )
		{	sospOP++;
			codaOP.await();
			sospOP--;
		}
		if (pronto(mis1))
		{	scarpe_mis1[dx]--;
			scarpe_mis1[sn]--;
			coda_mis1[dx].signal();
			coda_mis1[sn].signal();
			System.out.print("PRELIEVO di un paio di scarpe di MISURA "+mis1+" [sospesiDX1="+sosp_mis1[dx]+", sospesiDX2="+sosp_mis2[dx]+", sospesiSN1="+sosp_mis1[sn]+", sospesiSN2="+sosp_mis2[sn]+"] \n");
		}
		else
		{	scarpe_mis2[dx]--;
			scarpe_mis2[sn]--;
			coda_mis2[dx].signal();
			coda_mis2[sn].signal();
			System.out.print("PRELIEVO di un paio di scarpe di MISURA "+mis2+" [sospesiDX1="+sosp_mis1[dx]+", sospesiDX2="+sosp_mis2[dx]+", sospesiSN1="+sosp_mis1[sn]+", sospesiSN2="+sosp_mis2[sn]+"] \n");
	
		
				}
	} finally{ lock.unlock();}
	return;
}

public void deposito(int p, int m)throws InterruptedException
{	lock.lock();
	try
  { 	while	(	m==mis1 && scarpe_mis1[p]==MAX/4 ||
					m==mis2 && scarpe_mis2[p]==MAX/4 )
			if	(m==mis1)
			{	sosp_mis1[p]++;
				coda_mis1[p].await();
				sosp_mis1[p]--;
			}
			else
			{	sosp_mis2[p]++;
				coda_mis2[p].await();
				sosp_mis2[p]--;
			}
	if (m==mis1) 
	{	scarpe_mis1[p]++;
		System.out.print("DEPOSITO di una scarpa  di piede "+p+" e  MISURA 1... \n");
	}
	else 
	{	scarpe_mis2[p]++;	
		System.out.print("DEPOSITO di una scarpa  di piede "+p+" e  MISURA 2... \n");
	}

	if (pronto(m)&&(sospOP>0))
			codaOP.signal();
 } finally{ lock.unlock();}
 return;
}


}
