import java.util.concurrent.locks.*;


public class monitor {
	private final int MAX=20;	//capacita` della terrazza
	//costanti di direzione:
	private final int EST=0;
	private final int OVEST=1;
	
	private Lock lock = new ReentrantLock();
	private int dentro; //persone nella terrazza
	private Condition []codaTE=new Condition[2]; // code in ingresso al tratto E
	private Condition []codaTO=new Condition[2]; // code in ingresso al tratto O
	private int []sospTE=new int[2]; //persone sospese nell'accesso a TE per ogni direzione
	private int []sospTO=new int[2]; //persone sospese nell'accesso a TO  per ogni direzione
	private int []inE=new int[2]; 	//persone nel tratto E per ogni direzione
	private int []inO=new int[2]; 	//persone nel tratto O per ogni direzione
	
	
	

	
	public monitor() 
	{
		int i;
		for (i=0; i<2; i++)
		{	inE[i]=0; 
			inO[i]=0; 
			sospTE[i]=0; 
			sospTO[i]=0;
			codaTE[i]=lock.newCondition();
			codaTO[i]=lock.newCondition();
		}
		
		dentro=0;		
	}
	
	

	public void EntraTrattoE(int d) throws InterruptedException { 
		lock.lock();
		try {
			if (d==EST)
			{	while ((inE[OVEST]>0) || (dentro+inE[EST]+inO[OVEST]==MAX) ||sospTE[OVEST]>0) 
				{	sospTE[d]++;
					codaTE[d].await();
					sospTE[d]--;
				}
			
				inE[d]++;
				
			}
			else //il thread proviene da OVEST
			{	while  (inE[EST]>0) 
				{	sospTE[d]++;
					codaTE[d].await();
					sospTE[d]--;
				}
			
				dentro--;
				inE[d]++;
				
				if ((sospTO[OVEST]>0)&&(inO[EST]==0)&& (sospTO[EST]==0))
					codaTO[OVEST].signal();
				
			}			
		System.out.println("visitatore  entrato nel tratto E in direzione"+d);	
		stampa();
		} finally {
			lock.unlock();
		}
	}
	public void EntraTrattoO(int d) throws InterruptedException { 
		lock.lock();
		try {
			if (d==OVEST)
			{	while ((inO[EST]>0) || (dentro+inO[OVEST]+inE[EST]==MAX) ||sospTO[EST]>0) 
				{	sospTO[d]++;
					codaTO[d].await();
					sospTO[d]--;
				}
			
				inO[d]++;
				
			}
			else //il thread proviene da EST: esce dalla terrazza
			{	while  (inO[OVEST]>0)
				{	sospTO[d]++;
					codaTO[d].await();
					sospTO[d]--;
				}
			
				dentro--;
				inO[d]++;
				
				if ((sospTE[EST]>0)&&(inE[OVEST]==0)&& (sospTE[OVEST]==0))
					codaTE[EST].signal();
				
			}			
		System.out.println("visitatore  entrato nel tratto O in direzione"+d);	
		stampa();
		} finally {
			lock.unlock();
		}
	}
	
	
	public void EsciTrattoE(int d) throws InterruptedException {
		lock.lock();
		try {
			inE[d]--; 
			if (d==EST) // entra nella terrazza
			{	dentro++;
				if (inE[d]==0 && sospTE[OVEST]>0)
					codaTE[OVEST].signalAll();
			}
			else // d==OVEST
				if ((inE[d]==0)&& (dentro<MAX) && (sospTE[OVEST]==0) && (sospTE[EST]>0))
					codaTE[EST].signalAll();
			System.out.println("visitatore uscito dal tratto E in direzione"+d);		
			stampa();
			
		} finally {
			lock.unlock();
		}
	}
	
	public void EsciTrattoO(int d) throws InterruptedException {
		lock.lock();
		try {
			inO[d]--; 
			if (d==OVEST) // entra nella terrazza
			{	dentro++;
				if (inO[d]==0 && sospTO[EST]>0)
					codaTO[EST].signalAll();
			}
			else // d==EST
				if ((inO[d]==0)&& (dentro<MAX) && (sospTO[EST]==0) && (sospTO[OVEST]>0))
					codaTO[OVEST].signalAll();
			System.out.println("visitatore  uscito dal tratto O in direzione"+d);	
			stampa();	
			
		} finally {
			lock.unlock();
		}
	}
	
	
	private void stampa()
	{  System.out.print("visitatori nella terrazza: "+dentro+" - sospTE[EST]: "+sospTE[EST]+" - sospTE[OVEST]: "+sospTE[OVEST]+" - sospTO[EST]: "+sospTO[EST]+" - sospTO[OVEST]: "+ sospTO[OVEST]+ "\n");
	return;
		}
	
	}
