#include <fcntl.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#define MAXLINE 80
#define THRES 3

/* Used to count the signals */
int counter = 0;
void handle_count(int signo);
/* Implements the functionality of reading and filtering from
   the input file */
void reader(char *inputfile, char filter, int dest, int wpid);
/* Implements the functionality of writing the correct result
   to the output file */
void writer(char *outputfile, int src, char c[]);

int main(int argc, char **argv) {

    int pid[2], pfd[2], i = 0;
    if ( 5 != argc ) {
        fprintf(stderr, "Wrong number of arguments\n");
        exit(1);
    }

    if (1 != strlen(argv[3]) || 1 != strlen(argv[4])) {
        fprintf(stderr, "c1 and c2 must be one character strings\n");
        exit(1);
    }

    if (signal(SIGUSR1, &handle_count) == SIG_ERR) {
        perror("Unable to set handler");
        exit(1);
    }

    if ( pipe(pfd) < 0 ) {
        perror("Problems while creating pipe");
        exit(1);
    }
    
    for (; i<2; i++ ){
        pid[i] = fork();
        if ( pid[i] > 0 ) {
            /* Just continue */
        } else if ( pid[i] < 0 ) {
            perror("Unable to fork");
            if (i == 1) kill(pid[0], SIGTERM);
            exit(1);
        } else {
            if ( 1 == i ) {
                signal(SIGUSR1, SIG_DFL);
                close(pfd[0]);
                reader(argv[1], '#', pfd[1], pid[0]);
                exit(0);
            }
            else if ( 0 == i ) {
                char c[2]; c[0] = argv[3][0]; c[1] = argv[4][0];
                close(pfd[1]);
                writer(argv[2], pfd[0], c);
                exit(0);
            }
            else {
                fprintf(stderr, "Unexpected process id");
                exit(1);
            }
                
        }

    }
    close(pfd[0]); close(pfd[1]);
    signal(SIGUSR1, SIG_DFL);
    wait(NULL); wait(NULL);
    return 0;
}


void handle_count(int signo) {
    counter +=1;
}

void reader(char *inputfile, char filter, int dest, int wpid) {
    /*
     * fd: file descriptor of the input file (once it will be opened)
     * firstLineChar: 1 indicates that we are going to read the first
     *                character of a new line.
     * out: 1 indicates that the current line must be sent over the
     *      pipe.
     */
    int fd, firstLineChar = 1, out = 1;
    char el;

    printf("Reader: pid %d\n", getpid());
    if ( ( fd = open(inputfile, O_RDONLY) ) < 0 ) {
        perror("Unable to open input");
        kill(wpid, SIGTERM);
        exit(1);
    }

    while (  read(fd, &el, sizeof(char)) > 0) {
        if (firstLineChar) {
            if ('#' == el) {
                if (kill(wpid, SIGUSR1) < 0 ){
                    perror("Unable to send signal");
                    exit(1);
                }
		/* Avoids loosing signals*/
                sleep(1);
		/* Disable output */
                out = 0;
            }
	    /* The first character of the line has been read*/
            firstLineChar = 0;
        }

        if (out) {
            printf("%c",el);
            if (write(dest, &el, sizeof(char)) < 0) {
                perror("Impossible to write to destination");
                exit(1);
            }
        }

        if ( '\n' == el ) {
            firstLineChar = 1;
            out = 1;
        } 
    }

    close(fd); close(dest);
}
void writer(char *outputfile, int src, char c[] ){

    /*
     * fd: file descriptor of the output file
     * count1: counter used to count the occurrences of c[0]
     *         in a line
     * count2: counter used to count the occurrences of c[1]
     *         in a line
     * lc1: number of lines containing at least THRES occurrences
     *      of c[0]
     * lc2: number of lines containing at least THRES occurrences
     *      of c[1]
     */
    int fd, count1 = 0, count2 = 0, lc1 = 0, lc2 =0;
    char el, buff[MAXLINE+1];

    printf("Writer: pid %d\n", getpid());

    
    while ( (read(src, &el, sizeof(char))) > 0 ) {
        if (c[0] == el) count1 += 1;
        else if (c[1] == el) count2 += 1;
        else if ('\n' == el) {
            if ( THRES <= count1 ) lc1 += 1;
            if ( THRES <= count2 ) lc2 += 1;
            count1 = 0; count2 = 0;
        }
    }
    close(src);
    /* As soon as the process will be out of the while above, it will
     * have received all the expected signals.
     */


    if ( ( fd = open(outputfile, O_WRONLY | O_CREAT | O_APPEND, 0755) ) < 0 ) {
        perror("Unable to open output");
        exit(1);
    }

    if (counter % 2 == 0) {
        lc2 = lc1;
        c[1] = c[0];
    } 
    
    sprintf(buff, "Ci sono state %d occorrenze del carattere %c\n", lc1, c[1]);
    write(fd, buff, strlen(buff)*sizeof(char));

    close(fd);


}
