//
//  monitor.java
//  forno
//
//  Created by anna ciampolini on 13/06/12.
//  Copyright 2012 __MyCompanyName__. All rights reserved.
//

import java.util.concurrent.locks.*;

public class monitor
{	

	private final int MAX = 4; 
	
	private final int ristorante = 0; 
	private final int negozio = 1; 
	private final int F = 0; 
	private final int P = 1;
	private final int Tlow=170; //temperatura bassa
	private final int Thigh=250; //temperatura alta

	private Lock mutex = new ReentrantLock();
	
		
	//Code
	private Condition codaF[] = new Condition[2];		//prodotti di tipo F in attesa
    private int sospF[] = new int[2];
	private Condition codaP[] = new Condition[2];		//prodotti di tipo P in attesa
    private int sospP[] = new int[2];


	private int inforno[] = new int[2];					//teglie nel forno
	private int temperatura;
	
	public monitor( ) 
	{	
			for( int i=0 ; i<2 ; i++ )
		{	codaF[i] = mutex.newCondition();
			sospF[i] = 0;
			codaP[i] = mutex.newCondition();
			sospP[i] = 0;
			inforno[i] = 0;
		}
		temperatura=Thigh;
		
		
	}


	public void entraF(int dest) throws InterruptedException //entrata prodotto F
	{			mutex.lock();
		try
		{	while ( (temperatura==Tlow && inforno[P]>0)  || 
					 inforno[F]==MAX|| 
					 (dest==negozio && sospF[ristorante]>0))			
			{	sospF[dest]++;
				//System.out.println("prodotto F("+dest+") :  ATTENDO");
				codaF[dest].await();
				sospF[dest]--;
			}
			if (temperatura==Tlow) temperatura=Thigh;
			inforno[F]++;
			
			System.out.println("prodotto F("+dest+") :  ENTRO!! --nel forno: F="+inforno[F]+",  P="+inforno[P]+" --SOSPESI  F[r]="+sospF[ristorante]+", F[n]="+sospF[negozio]+", P[r]="+sospP[ristorante]+", P[n]="+sospP[negozio] );

			
		}
		finally
		{ mutex.unlock();
		}
	}
	
	public void esceF () throws InterruptedException //uscita prodotto F
	{	// todo:
		mutex.lock();
		try
		{
			inforno[F]--;
			System.out.println("prodotto F :  ESCO!! --nel forno: F="+inforno[F]+",  P="+inforno[P]+" --SOSPESI  F[r]="+sospF[ristorante]+", F[n]="+sospF[negozio]+", P[r]="+sospP[ristorante]+", P[n]="+sospP[negozio] );


			if( sospF[ristorante] > 0 )
				codaF[ristorante].signal();
			else if( sospF[negozio] > 0 )
				codaF[negozio].signal();
			else if (inforno[F]==0)
			{		if (sospP[ristorante]>0)
						codaP[ristorante].signalAll();
					if (sospP[negozio]>0)
						codaP[negozio].signalAll();
			}
						
		}
		finally
		{ mutex.unlock();
		}		
	}

public void entraP(int dest) throws InterruptedException //entrata prodotto F
	{			mutex.lock();
		try
		{	while ( (temperatura==Thigh && inforno[F]>0)  || 
					 inforno[P]==MAX|| 
					 sospF[ristorante]>0 ||
					 sospF[negozio]>0 ||
					 (dest==negozio && sospP[ristorante]>0))			
			{	sospP[dest]++;
				//System.out.println("prodotto P("+dest+") :  ATTENDO");
				codaP[dest].await();
				sospP[dest]--;
			}
			if (temperatura==Thigh) temperatura=Tlow;
			inforno[P]++;
			
			System.out.println("prodotto P("+dest+") :  ENTRO!! --nel forno: F="+inforno[F]+",  P="+inforno[P]+" --SOSPESI  F[r]="+sospF[ristorante]+", F[n]="+sospF[negozio]+", P[r]="+sospP[ristorante]+", P[n]="+sospP[negozio] );


		}
		finally
		{ mutex.unlock();
		}
	}
	
public void esceP () throws InterruptedException //uscita prodotto P
{	
		mutex.lock();
		try
		{
			inforno[P]--;
			System.out.println("prodotto P:  ESCO!! --nel forno: F="+inforno[F]+",  P="+inforno[P]+" --SOSPESI  F[r]="+sospF[ristorante]+", F[n]="+sospF[negozio]+", P[r]="+sospP[ristorante]+", P[n]="+sospP[negozio] );


			
			if( inforno[P]==0)
			{	if (sospF[ristorante] > 0 )
					codaF[ristorante].signalAll();
				if (sospF[negozio] > 0 )
					codaF[negozio].signalAll();
			}
			else if( sospF[ristorante] ==0 &&  sospF[negozio] ==0)
			{	if (sospP[ristorante]>0)
					codaP[ristorante].signal();
				else if (sospP[negozio]>0)
						codaP[negozio].signal();
			}
				
		}
		finally
		{ mutex.unlock();
		}		
	}
}// fine monitor