//
//  monitor.java
//  banca
//
//  Created by anna ciampolini on 21/06/10.
//  Copyright 2010 __MyCompanyName__. All rights reserved.
//


import java.util.concurrent.locks.*;

public class monitor
{ //Dati:
private final int N=20; //costante che esprime il massimo numero di CC
private final int VIP=0; //TIPO VIP
private final int STA=1; //TIPO CLIENTE STANDARD
private final int soglia=50000;
private int[] CC; //CONTI CORRENTIi

private Lock lock= new ReentrantLock();
private Condition VV= lock.newCondition();  //coda Vip che vogliono versare
private Condition VS= lock.newCondition(); //coda Standard che vogliono versare
private Condition PV= lock.newCondition(); //coda Vip che vogliono prelevare
private Condition PS= lock.newCondition(); //coda Standard ch vogliono prelevare
private int  sospVV,  sospVS; 
private int  sospPV, sospPS; 

boolean occupato; //presenza di un cliente allo sportello

//Costruttore:
public monitor( ) {
int i;

CC=new int[N];
for(i=0; i<N; i++)
	CC[i]=0;

occupato=false;

sospPV=0;
sospPS=0;
sospVV=0;
sospVS=0;

}

private int tipo(int conto)
{	if (CC[conto] < soglia) 
		return STA;
	else 
		return VIP;
}


//metodi "entry":

public void prelievo(int conto, int somma) throws InterruptedException
{	lock.lock();
	try
  { 	while	(	occupato||
					CC[conto]<somma ||
					((sospPV > 0) && (tipo(conto)==STA))|| 
					sospVV>0 || sospVS>0)
         	if	(tipo(conto) == VIP)
			{	sospPV++;
				PV.await();
				sospPV--;
			}
			else
			{	sospPS++;
				PS.await();
				sospPS--;
			}
		occupato=true;
		CC[conto]-=somma;
		
       	if (tipo(conto) == VIP)
			System.out.print("PREL.  VIP di "+somma+" dal conto "+conto+": ci sono "+CC[conto]+" euro  nel conto - [VV: "+sospVV+"; VS: "+sospVS+"; PV: "+sospPV+"; PS: "+sospPS+"]... \n");
		else 
			System.out.print("PREL.  STA di "+somma+" dal conto "+conto+": ci sono "+CC[conto]+" euro  nel conto - [VV: "+sospVV+"; VS: "+sospVS+"; PV: "+sospPV+"; PS: "+sospPS+"]... \n");
	

		} finally{ lock.unlock();}
	return;
}

public void versamento(int conto, int mioconto, int somma)throws InterruptedException
{	lock.lock();
	try
  { 	while	(	occupato||
					((sospVV > 0) && (tipo(mioconto)==STA)))
		if	(tipo(mioconto) == VIP)
			{	sospVV++;
				VV.await();
				sospVV--;
			}
			else
			{	sospVS++;
				VS.await();
				sospVS--;
			}
		
		occupato=true;
		CC[conto]+=somma;
		         
       	if (tipo(mioconto) == VIP)
			System.out.print("VERS.  VIP di "+somma+" sul conto "+conto+": ci sono "+CC[conto]+" euro  nel conto - [VV: "+sospVV+"; VS: "+sospVS+"; PV: "+sospPV+"; PS: "+sospPS+"]... \n");
		else 
			System.out.print("VERS.  STA di "+somma+" sul conto "+conto+": ci sono "+CC[conto]+" euro  nel conto - [VV: "+sospVV+"; VS: "+sospVS+"; PV: "+sospPV+"; PS: "+sospPS+"]... \n");
	
		} finally{ lock.unlock();}
	return;
}


public void fine_operazione()
{	lock.lock();
	try
  { 	occupato=false;
		if (sospVV>0)
			VV.signalAll(); // non conosco a priori il conto sul per il quale aspettano i thread sospesi
		if (sospVS>0)
			VS.signalAll();
         if (sospPV>0)
			PV.signalAll(); // non conosco a priori il conto sul per il quale aspettano i thread sospesi
		if (sospPS>0)
			PS.signalAll();
			
       	//System.out.print("FINE operazione\n");
		} finally{ lock.unlock();}
	return;

}
}
