<%@ page info="Home Page" %>
<%@ page contentType="text/html" %>
<%@ page session="false" %>
<%@ page buffer="30kb" %>
<%@ page errorPage="/ErrorPage.jsp" %>

<%@ page import="services.sessionservice.*" %>

<%@ taglib prefix="x" uri="http://java.sun.com/jstl/xml" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jstl/core" %>

<jsp:useBean id="logonManagement" scope="page" class="bflows.LogonManagement" />
<jsp:setProperty name="logonManagement" property="*" />

<%Cookie[] cookies=null;
  cookies=request.getCookies();
  
  boolean loggedOn=(cookies!=null);
  
  int i;
  String message=null;
  String status;

  status=request.getParameter("status");
  if (status==null) status="view";

  util.Debug.println("status: "+status);

  if (status.equals("logon")) {
    logonManagement.logon();    
    if (logonManagement.getCookies()!=null) {
      for(i=0;i<logonManagement.getCookies().length;i++)
        response.addCookie(logonManagement.getCookies(i));
      cookies=logonManagement.getCookies();
      loggedOn=true;      
    }
  }

  if (status.equals("logout")) {
    if (loggedOn) {
      logonManagement.setCookies(cookies);
      logonManagement.logout();    
      for(i=0;i<logonManagement.getCookies().length;i++)
        response.addCookie(logonManagement.getCookies(i));
      loggedOn=false;
    }
  }
  
  if (logonManagement.getResult()==-1){    
    throw new Exception("Errore nell'applicazione: consultare i logs.");
  } else if (logonManagement.getResult()==-2) {
    message=logonManagement.getErrorCode();
  }

%>

<c:set var="xmlDocument" scope="page">

<ROOT>  

  <%if (loggedOn) { %>
      <USER>
        <FIRSTNAME><%=Session.getUserFirstname(cookies)%></FIRSTNAME>
        <SURNAME><%=Session.getUserSurname(cookies)%></SURNAME>        
      </USER>
  <%}%>

  <FLOW>
    <logonForm>
      <input type="hidden" name="status" value="logon"/>
    </logonForm>
  </FLOW>

  <VAR>
    <LOGGEDON><%=loggedOn?"S":"N"%></LOGGEDON>
    <ALERTMSG ENABLED="<%=(message!=null)?"S":"N"%>"><%=message!=null?message:""%></ALERTMSG>
  </VAR>

</ROOT>

</c:set>

<x:parse xml="${xmlDocument}" var="xml"/>

<c:set var="xslUrl"><%="/XSL/"+(loggedOn?Session.getUserLanguageCode(cookies):"ENG")+"/home.xsl"%></c:set>
<c:import var="xslDocument" url="${xslUrl}" scope="page"/>
<x:parse xml="${xslDocument}" var="xsl"/>

<x:transform xml="${xml}" xslt="${xsl}"/>