<?xml version="1.0" encoding="ISO8859-1"?>

<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">	
  
  <xsl:template match="/">
    <xsl:output method="html" indent="no"/>
    <html>
      <head>
        <title>Rubrica - Logon</title>
        <meta name="author" content="Mario Zambrini"/>

        <link href="addressbook.css" rel="stylesheet" type="text/css"/>
        
        <!--xsl:call-template name="validationLibrary"/-->
        <script language="javascript">
        <![CDATA[

          function isEmpty(value) {

            if (value == null || value.length == 0)
              return true;
            for (var count = 0; count < value.length; count++) {
              if (value.charAt(count) != " ") return false;
            }
            return true;

          }                
        
          function submitLogon() {

            if (isEmpty(logonForm.userCode.value)) {
              alert("Inserire uno username.");
              return;
            }        

            if (isEmpty(logonForm.password.value)) {
              alert("Inserire una password.");
              return;
            }      
            
            logonForm.submit();
            
          }
        
        ]]>
        </script>
      </head>
      <body bgcolor="#FFFFFF" text="#000000">

        <span class="pageTitle">Rubrica</span>   
        <br/><br/>

        <span class="pageSubtitle">Logon</span>   
        <br/><br/>

        <form name="logonForm" action="home.jsp" method="post">

          <table border="0">
            <tr>
              <td class="normal" width="100">Username</td>
              <td width="250">
                <input type="text" name="userCode" size="20" maxlength="50"/>
              </td>
            </tr>
            <tr>
              <td class="normal" width="100">Password</td>
              <td width="250">
                <input type="password" name="password" size="20" maxlength="50"/>
              </td>
            </tr>
          </table>

          <xsl:for-each select="ROOT/FLOW/logonForm/*">
            <input type="{@type}" name="{@name}" value="{@value}"/>
          </xsl:for-each>                            
          <input type="button" value="Ok" onClick="submitLogon()"/>
        </form>
        
        <xsl:choose>
          <xsl:when test="ROOT/VAR/LOGGEDON='S'">
            Benvenuto <xsl:value-of select="ROOT/USER/FIRSTNAME"/> <xsl:value-of select="ROOT/USER/SURNAME"/>!<br/>
            Accedi alla <a href="AddressBookView.jsp">Rubrica</a>            
            <form name="logoutForm" action="home.jsp" method="post">
              <input type="hidden" name="status" value="logout"/>
            </form>
            <a href="javascript:logoutForm.submit()">Logout</a>
          </xsl:when>
          <xsl:otherwise>

          </xsl:otherwise>
        </xsl:choose>      							        
        
        <!-- =====[[ MESSAGE ]]===== -->
        <xsl:if test="ROOT/VAR/ALERTMSG[@ENABLED='S']">
          <script>
            <xsl:choose>
              <xsl:when test="ROOT/VAR/ALERTMSG='WRONG_CREDENTIALS'">
                <xsl:text>alert("Username e password errati!");</xsl:text>
              </xsl:when>
              <xsl:otherwise>
                <xsl:text>alert("</xsl:text>                    
                        <xsl:value-of select="ROOT/VAR/ALERTMSG" />	
                        <xsl:text>");</xsl:text>
              </xsl:otherwise>	
            </xsl:choose>          		
          </script>
        </xsl:if>
        <!-- =====[[ MESSAGE ]]===== -->        
        
      </body>

    </html>

  </xsl:template>

</xsl:stylesheet>