<?xml version="1.0" encoding="ISO8859-1"?>

<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  
  <xsl:template match="/">
    <xsl:output method="html" indent="no"/>
    <html>
      <head>        
        <title>Rubrica</title>      
        <meta name="author" content="Mario Zambrini"/>
        <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1"/>

        <link href="addressbook.css" rel="stylesheet" type="text/css"/>     				

        <script language="javascript">
          <![CDATA[										

          function changeInitial(inital) {
            document.changeInitialForm.selectedInitial.value=inital;            
            document.changeInitialForm.submit();
            return;
          }          
          
          function insertContact() {                     
            document.insertForm.submit();
            return;
          }                  
          
          function modifyContact(code,firstname,surname,sex,address,city,phone,email) {            
            f=document.modifyForm;
            
            f.contactCode.value=code;
            f.firstname.value=firstname;
            f.surname.value=surname;
            f.sex.value=sex;
            f.address.value=address;
            f.city.value=city;
            f.phone.value=phone;
            f.email.value=email;            						
            f.submit();
            return;
          }

          function deleteContact(code) {
            document.deleteForm.contactCode.value=code;
            document.deleteForm.submit();
            return;
          }          			

          ]]>
        </script>
      </head>

      <body bgcolor="#FFFFFF" text="#000000">

        <span class="pageTitle">Rubrica: <xsl:value-of select="ROOT/INITIALS/INITIAL[@SELECTED='S']"/></span>   
        <br/><br/>          
        
        <a href="javascript:insertContact();">Nuovo Contatto</a>
        <br/><br/>
        <xsl:apply-templates select="ROOT/INITIALS/INITIAL"/>
        <br/><br/>
        <xsl:apply-templates select="ROOT/CONTACTS/CONTACT"/>
                		
        <!-- =====[[ FLOW ]]===== -->
        <xsl:for-each select="ROOT/FLOW/form">
          <form name="{@name}" method="{@method}" action="{@action}">
            <xsl:for-each select="input">
              <input type="{@type}" name="{@name}" value="{@value}"/>
            </xsl:for-each>
          </form>
        </xsl:for-each>
        <!-- =====[[ FLOW ]]===== -->
        
        <!-- =====[[ MESSAGE ]]===== -->
        <xsl:if test="ROOT/VAR/ALERTMSG[@ENABLED='S']">
          <script>
            <xsl:choose>
              <xsl:when test="ROOT/VAR/ALERTMSG='DUPLICATED_CONTACT'">
                <xsl:text>alert("Il contatto inserito e gia' esistente.");</xsl:text>
              </xsl:when>
              <xsl:otherwise>
                <xsl:text>alert("</xsl:text>                    
                        <xsl:value-of select="ROOT/VAR/ALERTMSG" />	
                        <xsl:text>");</xsl:text>
              </xsl:otherwise>	
            </xsl:choose>          		
          </script>
        </xsl:if>
        <!-- =====[[ MESSAGE ]]===== -->        
        
      </body>
    </html>
  </xsl:template>

  <!-- =====[[ TEMPLATES  ]]===== -->

  <!-- =====[[ INITIALS  ]]===== -->
  <xsl:template match="INITIAL">
    <xsl:choose>
      <xsl:when test="@SELECTED='S'">
        <span class="selectedInitial"><xsl:value-of select="."/>&#160;</span>
      </xsl:when>
      <xsl:otherwise>
        <a class="initial" href="javascript:changeInitial('{.}');"><xsl:value-of select="."/>&#160;</a>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <!-- =====[[ /INITIALS  ]]===== -->

  <!-- =====[[ CONTACT  ]]===== -->
  <xsl:template match="CONTACT">
    <table border="0">
    <tr>
      <td width="25" valign="top" align="center"><img src="images/ITA/ball.gif"/></td>
      <td class="name" width="*">        
        <a href="javascript:modifyContact( {@CODE},'{FIRSTNAME}','{SURNAME}','{SEX}','{ADDRESS}','{CITY}','{PHONE}','{EMAIL}' )">
          <xsl:value-of select="SURNAME"/>, <xsl:value-of select="FIRSTNAME"/>
        </a>
      </td>
      <td width="25" align="center"><a href="javascript:deleteContact({@CODE})"><img src="images/ITA/delete.gif" border="0"/></a></td>
    </tr>
    <tr>
      <td>&#160;</td>
      <td>
        <span class="phone"><xsl:value-of select="PHONE"/></span>
        <address>
          <xsl:value-of select="ADDRESS"/><br/>
          <xsl:value-of select="CITY"/><br/>          
        </address>
      </td>
      <td>&#160;</td>      
    </tr>
  </table>
    
  </xsl:template>
  <!-- =====[[ /CONTACT  ]]===== -->
  
<!-- =====[[ /TEMPLATES  ]]===== -->
		
</xsl:stylesheet>


