<?xml version="1.0" encoding="ISO8859-1"?>

<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:template match="/">
    <xsl:output method="html" indent="no"/>
    <html>
      <head>
        <title>New Contact</title>
        <meta name="author" content="Mario Zambrini"/>
        <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1"/>

        <link href="addressbook.css" rel="stylesheet" type="text/css"/>     				
        								
	<script language="javascript">
          <![CDATA[										

          function isEmpty(value) {

            if (value == null || value.length == 0)
              return true;
            for (var count = 0; count < value.length; count++) {
              if (value.charAt(count) != " ") return false;
            }
            return true;

          }                  
          
          function isValidEmail(s) {
            if (s.indexOf("@") > 0 && (s.indexOf("@") < (s.length - 1) ) ) return true;
            return false;
          }          
          
          function insertContact() {

            f=document.insertForm;
          
            //Nome
            if (isEmpty(f.firstname.value)) {
              alert("Insert firstname.");
              return;
            }      

            //Cognome
            if (isEmpty(f.surname.value)) {
              alert("Insert surname.");
              return;
            }    

            //Indirizzo
            if (isEmpty(f.address.value)) {
              alert("Insert address.");
              return;
            }    

            //Citta'
            if (isEmpty(f.city.value)) {
              alert("Insert city.");
              return;
            }    

            //Telefono
            if (isEmpty(f.phone.value)) {
              alert("Insert phone.");
              return;
            }    

            //E-Mail
            if (isEmpty(f.email.value) || !isValidEmail(f.email.value)) {
              alert("Insert correct e-mail.");
              return;
            }   
            
            f.submit();
            return;
            
          }

          ]]>
        </script>
      </head>
      <body bgcolor="#FFFFFF" text="#000000">
      
        <span class="pageTitle">Address Book</span>   
        <br/><br/>

        <span class="pageSubtitle">New Contact</span>
        <br/><br/>      
                                    
        <form name="insertForm" action="AddressBookView.jsp" method="post">

          <table border="0">
            <tr>
              <td class="normal" width="100">Firstname</td>
              <td width="250">
                <input type="text" name="firstname" size="20" maxlength="50"/>
              </td>
            </tr>
            <tr>
              <td class="normal" width="100">Surname</td>
              <td width="250">
                <input type="text" name="surname" size="20" maxlength="50"/>
              </td>
            </tr>
            <tr>
              <td class="normal" width="100">Sex</td>
              <td width="250">
                <input type="radio" name="sex" value="M" checked="checked"/>M
                <input type="radio" name="sex" value="F"/>F
              </td>
            </tr>
            <tr>
              <td class="normal" width="100">Address</td>
              <td width="250">
                <input type="text" name="address" size="20" maxlength="50"/>
              </td>
            </tr>
            <tr>
              <td class="normal" width="100">City</td>
              <td width="250">
                <input type="text" name="city" size="20" maxlength="50"/>
              </td>
            </tr>
            <tr>
              <td class="normal" width="100">Phone</td>
              <td width="250">
                <input type="text" name="phone" size="20" maxlength="50"/>
              </td>
            </tr>
            <tr>
              <td class="normal" width="100">E-Mail</td>
              <td width="250">
                <input type="text" name="email" size="20" maxlength="50"/>
              </td>
            </tr>             
            <tr>
              <td class="normal" width="100">&#160;</td>
              <td width="250">
                <input type="button" value="ok" onClick="insertContact()"/>
                <input type="button" value="cancel" onClick="backForm.submit()"/>
              </td>
            </tr>
          </table>
          
          <xsl:for-each select="ROOT/FLOW/insertForm/*">
            <input type="{@type}" name="{@name}" value="{@value}"/>
          </xsl:for-each>											  				
         
        </form>

        <!-- =====[[ FLOW ]]===== -->
        <xsl:for-each select="ROOT/FLOW/form">
          <form name="{@name}" method="{@method}" action="{@action}">
            <xsl:for-each select="input">
              <input type="{@type}" name="{@name}" value="{@value}"/>
            </xsl:for-each>
          </form>
        </xsl:for-each>
        <!-- =====[[ FLOW ]]===== -->

      </body>
    </html>
    
  </xsl:template>

  <!-- =====[[ TEMPLATES  ]]===== -->

  <!-- =====[[ /TEMPLATES  ]]===== -->

</xsl:stylesheet>


