
package blogics;

import java.util.*;
import java.sql.*;

import util.*;
import services.databaseservice.*;
import services.databaseservice.exception.*;


public class ContactService extends Object {

  public ContactService() {}
  
  public static Contact insertNewContact(DataBase database,String userCode,
                            String firstname,String surname,String sex,
                            String address,String city,String phone,
                            String email)
    throws NotFoundDBException,DuplicatedRecordDBException,ResultSetDBException {

   Contact contact;

   contact=new Contact(userCode,firstname,surname,sex,address,
                       city,phone,email);
   contact.insert(database);
   return contact;

  }
  
  public static Vector getInitials(DataBase database, String userCode) 
    throws NotFoundDBException,ResultSetDBException {

    String initial;
    Vector initials=new Vector();    
    String sql;    
    
    sql=" SELECT DISTINCT UCase(Left(ACONTATTI.COGNOME,1)) AS INITIAL "+
        " FROM ACONTATTI "+
        " WHERE "+
        "   CD_USER='"+Conversion.getDatabaseString(userCode)+"' "+
        "   AND FL_ACTIVE='S' "+ 
        " ORDER BY UCase(Left(ACONTATTI.COGNOME,1))";
        
    ResultSet resultSet=database.select(sql);        
    
    try {

      while (resultSet.next()) {
        initial=resultSet.getString("INITIAL");
        initials.add(initial);
      }             
      
    } catch (SQLException ex) {
      throw new ResultSetDBException("ContactService: getInitials():  Errore nel ResultSet: "+ex.getMessage(),database);
    }

    return initials;

  }    
  
  public static Contact getContact(DataBase database,Long contactCode,String userCode) 
    throws NotFoundDBException,ResultSetDBException {

    Contact contact;
    String sql;
    
    sql=" SELECT *" +
        " FROM ACONTATTI "+
        " WHERE " +
        "   CD_USER='"+Conversion.getDatabaseString(userCode)+"' and "+
        "   CD_CONTACT=" +contactCode+ " and "+
        "   FL_ACTIVE='S'";

    ResultSet resultSet=database.select(sql);    

    try {

      if (resultSet.next()) {
        contact=new Contact(resultSet);
      } else {
        return null;
      }

    } catch (SQLException ex) {
      throw new ResultSetDBException("ContactService: getContact():  Errore nel ResultSet: "+ex.getMessage(),database);
    }

    return contact;

  }
  
  public static Vector getContacts(DataBase database, String userCode, String initial, String searchString) 
    throws NotFoundDBException,ResultSetDBException {

    Contact contact;
    Vector contacts=new Vector();    
    String sql ="";
    
    sql=" SELECT * FROM ACONTATTI "+
        " WHERE "+
        "   CD_USER='"+Conversion.getDatabaseString(userCode)+"' "+
        "   AND FL_ACTIVE='S' ";
    if (initial!=null)
        sql+=" AND UCASE(LEFT(COGNOME,1))='"+initial+"' ";
    if (searchString!=null) {
        sql+=" AND ( INSTR(COGNOME,'"+searchString+"')>0 ";
        sql+=" OR INSTR(NOME,'"+searchString+"')>0 ";
        sql+=" OR INSTR(VIA,'"+searchString+"')>0 ";
        sql+=" OR INSTR(CITTA,'"+searchString+"')>0 ";
        sql+=" OR INSTR(TEL,'"+searchString+"')>0 ";
        sql+=" OR INSTR(EMAIL,'"+searchString+"')>0 )";
    }
    sql += "ORDER BY COGNOME, NOME, EMAIL";
        
    util.Debug.println("MZ> "+sql);
    
    ResultSet resultSet=database.select(sql);        
    
    try {

      while (resultSet.next()) {
        contact=new Contact(resultSet);
        contacts.add(contact);
      }             
      
    } catch (SQLException ex) {
      throw new ResultSetDBException("ContactService: getContacts():  Errore nel ResultSet: "+ex.getMessage(),database);
    }

    return contacts;

  }

  
}