
package blogics;

import java.sql.*;

import util.*;
import services.databaseservice.*;
import services.databaseservice.exception.*;

public class Contact  {
  
  public Long contactCode;
  public String userCode;
  public String firstname;
  public String surname;
  public String sex;
  public String address;
  public String city;
  public String phone;
  public String email;
  public String active;
  public Timestamp timestamp;
  
  
  public Contact(String userCode, String firstname,
  String surname, String sex, String address,
  String city, String phone, String email) {
    
    this.userCode=userCode;
    this.firstname=firstname;
    this.surname=surname;
    this.sex=sex;
    this.address=address;
    this.city=city;
    this.phone=phone;
    this.email=email;
    
  }
  
  public Contact(ResultSet resultSet) {
    
    try {contactCode=new Long(resultSet.getLong("CD_CONTACT")); } catch (SQLException sqle) {}
    try {userCode=resultSet.getString("CD_USER");} catch (SQLException sqle) {}
    try {firstname=resultSet.getString("NOME");} catch (SQLException sqle) {}
    try {surname=resultSet.getString("COGNOME");} catch (SQLException sqle) {}
    try {sex=resultSet.getString("SEX");} catch (SQLException sqle) {}
    try {address=resultSet.getString("VIA");} catch (SQLException sqle) {}
    try {city=resultSet.getString("CITTA");} catch (SQLException sqle) {}
    
    try {phone=resultSet.getString("TEL");} catch (SQLException sqle) {}
    try {email=resultSet.getString("EMAIL");} catch (SQLException sqle) {}
    try {active=resultSet.getString("FL_ACTIVE");} catch (SQLException sqle) {}
    try {timestamp=resultSet.getTimestamp("TIMESTAMP");} catch (SQLException sqle) {}
    
  }
  
  
  public void insert(DataBase database)
  throws NotFoundDBException,DuplicatedRecordDBException,ResultSetDBException {
    
    String sql="";
    
    /* check di unicit */
    sql+= " SELECT CD_CONTACT "+
          "   FROM ACONTATTI "+
          " WHERE " +
          "   FL_ACTIVE='S' and "+
          "   NOME='" + Conversion.getDatabaseString(firstname)+"' and "+
          "   COGNOME='"+Conversion.getDatabaseString(surname)+"' and "+
          "   EMAIL='"+Conversion.getDatabaseString(email)+"' and "+
          "   CD_USER='"+Conversion.getDatabaseString(userCode)+"' ";
    
    ResultSet resultSet=database.select(sql);
    
    boolean exist=false;
    
    try {
      exist=resultSet.next();
      resultSet.close();
    } catch (SQLException e) {
      throw new ResultSetDBException("Contact: insert(): Errore sul ResultSet.");
    }
    
    if (exist) {
      throw new DuplicatedRecordDBException("Contact: insert(): Tentativo di inserimento di un contatto gi esistente.");
    }
    
    /* generazione CD_CONTACT */
    sql="SELECT MAX(CD_CONTACT) AS N FROM ACONTATTI";
    
    try {
      resultSet=database.select(sql);
      
      if (resultSet.next())
        contactCode = new Long(resultSet.getLong("N")+1);
      else
        contactCode = new Long(1);
      
      resultSet.close();
      
    } catch (SQLException e) {
      throw new ResultSetDBException("Contact: insert(): Errore sul ResultSet --> impossibile calcolare CD_CONTACT.");
    }
    
    /*  inserimento nuovo contatto */
    
    sql=" INSERT INTO ACONTATTI "+
        "   ( CD_CONTACT,CD_USER,"+
        "     NOME,COGNOME,"+
        "     SEX,VIA,"+
        "     CITTA,TEL,"+
        "     EMAIL,FL_ACTIVE "+
        "   ) "+
        " VALUES ("+
        contactCode+","+
        "'"+Conversion.getDatabaseString(userCode)+"',"+
        "'"+Conversion.getDatabaseString(firstname)+"',"+
        "'"+Conversion.getDatabaseString(surname)+"',"+
        "'"+Conversion.getDatabaseString(sex)+"',"+
        "'"+Conversion.getDatabaseString(address)+"',"+
        "'"+Conversion.getDatabaseString(city)+"',"+
        "'"+Conversion.getDatabaseString(phone)+"',"+
        "'"+Conversion.getDatabaseString(email)+"',"+
        "'S')";
    
    database.modify(sql);
    
  }
  
  
  
  public void update(DataBase database) 
    throws NotFoundDBException,ResultSetDBException,DuplicatedRecordDBException {
      
    String sql="";
        
    /* check di unicit */
    sql+= " SELECT CD_CONTACT "+
          "   FROM ACONTATTI "+
          " WHERE " +
          "   FL_ACTIVE='S' and "+
          "   CD_CONTACT<>"+contactCode+" and "+
          "   NOME='" + Conversion.getDatabaseString(firstname)+"' and "+
          "   COGNOME='"+Conversion.getDatabaseString(surname)+"' and "+
          "   EMAIL='"+Conversion.getDatabaseString(email)+"' and "+
          "   CD_USER='"+Conversion.getDatabaseString(userCode)+"' ";
    
    ResultSet resultSet=database.select(sql);
    
    boolean exist=false;
    
    try {      
      exist=resultSet.next();
      resultSet.close();      
    } catch (SQLException e) {      
      throw new ResultSetDBException("Contact: update(): Errore sul ResultSet.");
    }
    
    if (exist) {
      throw new DuplicatedRecordDBException("Contact: update(): Tentativo di inserimento di "+
      "un contatto gi esistente.");
    }
        
    sql=" UPDATE ACONTATTI "+
        " SET "+
        "   NOME = '"+Conversion.getDatabaseString(firstname)+"', "+
        "   COGNOME = '"+Conversion.getDatabaseString(surname)+"', "+
        "   SEX= '"+Conversion.getDatabaseString(sex)+"',"+
        "   VIA = '"+Conversion.getDatabaseString(address)+"', "+
        "   CITTA = '"+Conversion.getDatabaseString(city)+"', "+
        "   TEL = '"+Conversion.getDatabaseString(phone)+"', "+
        "   EMAIL = '"+Conversion.getDatabaseString(email)+"', "+
        "   FL_ACTIVE = '"+Conversion.getDatabaseString(active)+"' "+
    
        " WHERE "+
        "   CD_CONTACT = "+contactCode+" ";
    
    database.modify(sql);
        
  }
  
  public void delete(DataBase database) 
  throws NotFoundDBException,ResultSetDBException {
    
    String sql;
    
    sql=" UPDATE ACONTATTI "+
        " SET FL_ACTIVE='N' "+
        " WHERE "+
        " CD_CONTACT="+contactCode+"";
    
    database.modify(sql);        
    
  }
  
}