
package bflows;

import java.beans.*;
import javax.servlet.http.*;

import services.databaseservice.*;
import services.databaseservice.exception.*;
import services.errorservice.*;
import services.sessionservice.*;
import blogics.*;

/**
 *
 * @author  Mario Zambrini
 *
 */
public class LogonManagement extends Object implements java.io.Serializable{
  
  /** Holds value of property result. */
  private int result;
  
  /** Holds value of property userCode. */
  private String userCode;
  
  /** Holds value of property password. */
  private String password;
  
  /** Holds value of property cookies. */
  private Cookie[] cookies;
    
  /** Holds value of property errorCode. */
  private String errorCode;
  
  public LogonManagement() {}
  
  public void logon() {
    
    DataBase database = null;
    
    try {
      
      database=DBService.getDataBase();
      
      User user=UserService.getUser(database,userCode);
      if (user== null || !user.password.equals(password)) {
        cookies=null;
        setResult(EService.RECOVERABLE_ERROR);
        setErrorCode("WRONG_CREDENTIALS");
        //setErrorMessage("Username e password errati!");
      } else {
        cookies=Session.createCookie(database,user.userCode);
      }
      
      database.commit();
      
    } catch (NotFoundDBException ex) {
      
      EService.logAndRecover(ex);
      setResult(EService.UNRECOVERABLE_ERROR);
      
    } catch (ResultSetDBException ex) {
      
      EService.logAndRecover(ex);
      setResult(EService.UNRECOVERABLE_ERROR);
      
    } finally {
      try { database.close(); }
      catch (NotFoundDBException e) { EService.logAndRecover(e); }
    }
    
  }
  
  public void logout() {    
    cookies=Session.deleteCookie(cookies);                
  }
  /** Getter for property result.
   * @return Value of property result.
   */
  public int getResult() {
    return this.result;
  }
  
  /** Setter for property result.
   * @param result New value of property result.
   */
  public void setResult(int result) {
    this.result = result;
  }
  
  /** Getter for property userCode.
   * @return Value of property userCode.
   */
  public String getUserCode() {
    return this.userCode;
  }
  
  /** Setter for property userCode.
   * @param userCode New value of property userCode.
   */
  public void setUserCode(String userCode) {
    this.userCode = userCode;
  }
  
  /** Getter for property password.
   * @return Value of property password.
   */
  public String getPassword() {
    return this.password;
  }
  
  /** Setter for property password.
   * @param password New value of property password.
   */
  public void setPassword(String password) {
    this.password = password;
  }
  
  /** Indexed getter for property cookies.
   * @param index Index of the property.
   * @return Value of the property at <CODE>index</CODE>.
   */
  public Cookie getCookies(int index) {
    return this.cookies[index];
  }
  
  /** Getter for property cookies.
   * @return Value of property cookies.
   */
  public Cookie[] getCookies() {
    return this.cookies;
  }
  
  /** Indexed setter for property cookies.
   * @param index Index of the property.
   * @param cookies New value of the property at <CODE>index</CODE>.
   */
  public void setCookies(int index, Cookie cookies) {
    this.cookies[index] = cookies;
  }
  
  /** Setter for property cookies.
   * @param cookies New value of property cookies.
   */
  public void setCookies(Cookie[] cookies) {
    this.cookies = cookies;
  }
  
  /** Getter for property errorCode.
   * @return Value of property errorCode.
   */
  public String getErrorCode() {
    return this.errorCode;
  }
  
  /** Setter for property errorCode.
   * @param errorCode New value of property errorCode.
   */
  public void setErrorCode(String errorCode) {
    this.errorCode = errorCode;
  }
  
}
