<%@ page info="Modifica Contatto" %>
<%@ page contentType="text/html" %>
<%@ page session="false" %>
<%@ page buffer="20kb" %>
<%@ page errorPage="/ErrorPage.jsp" %>

<%@ page import="services.sessionservice.*" %>

<%@ taglib prefix="x" uri="http://java.sun.com/jstl/xml" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jstl/core" %>

<jsp:useBean id="contactManagement" scope="page" class="bflows.ContactManagement" />
<jsp:setProperty name="contactManagement" property="*" />

<%int i;

  Cookie[] cookies=null;
  cookies=request.getCookies();
  contactManagement.setUserCode(Session.getUserCode(cookies));
  
  String status;
  status=request.getParameter("status");

  String message=null;

  if (status.equals("modify"))
     contactManagement.contactManagementModify();    
    
  if (contactManagement.getResult()==-1){
    throw new Exception("Errore nell'applicazione: consultare i logs.");
  } else if (contactManagement.getResult()==-2) {
    message=contactManagement.getErrorCode();
  }

%>

<c:set var="xmlDocument" scope="page">

<ROOT>

  <CONTACT CODE="<%=request.getParameter("contactCode")%>">
    <FIRSTNAME><%=request.getParameter("firstname")%></FIRSTNAME>
    <SURNAME><%=request.getParameter("surname")%></SURNAME>
    <SEX><%= request.getParameter("sex")%></SEX>
    <ADDRESS><%= request.getParameter("address")%></ADDRESS>
    <CITY><%= request.getParameter("city")%></CITY>
    <PHONE><%= request.getParameter("phone")%></PHONE>            
    <EMAIL><%=request.getParameter("email")%></EMAIL>      
  </CONTACT>

  <FLOW>

    <modifyForm>
      <input type="hidden" name="contactCode" value="<%=request.getParameter("contactCode")%>" />
      <input type="hidden" name="selectedInitial" value="<%=contactManagement.getSelectedInitial()%>"/>  
      <input type="hidden" name="status" value="modify" />
    </modifyForm>

    <form name="backForm" method="post" action="AddressBookView.jsp">
       <input type="hidden" name="selectedInitial" value="<%=contactManagement.getSelectedInitial()%>"/>  
       <input type="hidden" name="status" value="view"/>
    </form>

  </FLOW>

  <VAR>
    <ALERTMSG ENABLED="<%=(message!=null)?"S":"N"%>"><%=message!=null?message:""%></ALERTMSG>
  </VAR>

</ROOT>

</c:set>

<x:parse xml="${xmlDocument}" var="xml"/>

<c:set var="xslUrl"><%="/XSL/"+Session.getUserLanguageCode(cookies)+"/AddressBookModify.xsl"%></c:set>
<c:import var="xslDocument" url="${xslUrl}" scope="page"/>
<x:parse xml="${xslDocument}" var="xsl"/>

<x:transform xml="${xml}" xslt="${xsl}"/>