<?xml version="1.0" encoding="ISO8859-1"?>

<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:template match="/">  
    <xsl:output method="html" indent="no"/>
    <html>
      <head>
        <title>Modifica Contatto</title>
        <meta name="author" content="Mario Zambrini"/>
        <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1"/>

        <link href="addressbook.css" rel="stylesheet" type="text/css"/>     				

        <script language="javascript">
          <![CDATA[										

          function isEmpty(value) {

            if (value == null || value.length == 0)
              return true;
            for (var count = 0; count < value.length; count++) {
              if (value.charAt(count) != " ") return false;
            }
            return true;

          }                  

          function isValidEmail(s) {
            if (s.indexOf("@") > 0 && (s.indexOf("@") < (s.length - 1) ) ) return true;
            return false;
          }          

          function modifyContact() {

            f=document.modifyForm;

            //Nome
            if (isEmpty(f.firstname.value)) {
              alert("Inserire il nome.");
              return;
            }      

            //Cognome
            if (isEmpty(f.surname.value)) {
              alert("Inserire il cognome.");
              return;
            }    

            //Indirizzo
            if (isEmpty(f.address.value)) {
              alert("Inserire l'indirizzo.");
              return;
            }    

            //Citta'
            if (isEmpty(f.city.value)) {
              alert("Inserire la citta'.");
              return;
            }    

            //Telefono
            if (isEmpty(f.phone.value)) {
              alert("Inserire il telefono.");
              return;
            }    

            //E-Mail
            if (isEmpty(f.email.value) || !isValidEmail(f.email.value)) {
              alert("Inserire una e-mail corretta.");
              return;
            }   

            f.submit();
            return;

          }


          ]]>
        </script>
      </head>
      <body bgcolor="#FFFFFF" text="#000000">
      
        <span class="pageTitle">Rubrica</span>   
        <br/><br/>

        <span class="pageSubtitle">Modifica Contatto</span>
        <br/><br/>      			
        
        <form name="modifyForm" action="AddressBookModify.jsp" method="post">

          <table border="0">
            <tr>
              <td class="normal" width="100">Nome</td>
              <td width="250">
                <input type="text" name="firstname" value="{ROOT/CONTACT/FIRSTNAME}" size="20" maxlength="50"/>
              </td>
            </tr>
            <tr>
              <td class="normal" width="100">Cognome</td>
              <td width="250">
                <input type="text" name="surname" value="{ROOT/CONTACT/SURNAME}" size="20" maxlength="50"/>
              </td>
            </tr>
            <tr>
              <td class="normal" width="100">Sesso</td>
              <td width="250">
                <input type="radio" name="sex" value="M">
                  <xsl:if test="ROOT/CONTACT/SEX='M'">
                    <xsl:attribute name="checked">checked</xsl:attribute>
                  </xsl:if>					
                </input>M 
		<input type="radio" name="sex" value="F">
                  <xsl:if test="ROOT/CONTACT/SEX='F'">
                    <xsl:attribute name="checked">checked</xsl:attribute>
                  </xsl:if>																
                </input>F							              
              </td>
            </tr>
            <tr>
              <td class="normal" width="100">Indirizzo</td>
              <td width="250">
                <input type="text" name="address" value="{ROOT/CONTACT/ADDRESS}" size="20" maxlength="50"/>
              </td>
            </tr>
            <tr>
              <td class="normal" width="100">Citt&#224;</td>
              <td width="250">
                <input type="text" name="city" value="{ROOT/CONTACT/CITY}" size="20" maxlength="50"/>
              </td>
            </tr>
            <tr>
              <td class="normal" width="100">Telefono</td>
              <td width="250">
                <input type="text" name="phone" value="{ROOT/CONTACT/PHONE}" size="20" maxlength="50"/>
              </td>
            </tr>
            <tr>
              <td class="normal" width="100">E-Mail</td>
              <td width="250">
                <input type="text" name="email" value="{ROOT/CONTACT/EMAIL}" size="20" maxlength="50"/>
              </td>
            </tr>             
            <tr>
              <td class="normal" width="100">&#160;</td>
              <td width="250">
                <input type="button" value="invia" onClick="modifyContact()"/>
                <input type="button" value="indietro" onClick="backForm.submit()"/>
              </td>
            </tr>
          </table>
          
          <xsl:for-each select="ROOT/FLOW/modifyForm/*">
            <input type="{@type}" name="{@name}" value="{@value}"/>
          </xsl:for-each>											  				
         
        </form>
							
        <!-- =====[[ FLOW ]]===== -->
        <xsl:for-each select="ROOT/FLOW/form">
          <form name="{@name}" method="{@method}" action="{@action}">
            <xsl:for-each select="input">
              <input type="{@type}" name="{@name}" value="{@value}"/>
            </xsl:for-each>
          </form>
        </xsl:for-each>
        <!-- =====[[ FLOW ]]===== -->
        
        <!-- =====[[ MESSAGE ]]===== -->
        <xsl:if test="ROOT/VAR/ALERTMSG[@ENABLED='S']">
          <script>
            <xsl:text>alert("</xsl:text>
            <xsl:value-of select="ROOT/VAR/ALERTMSG" />	
            <xsl:text>");</xsl:text>			
          </script>
        </xsl:if>
        <!-- =====[[ MESSAGE ]]===== -->
      </body>
    </html>
  </xsl:template>
  <!-- =====[[ TEMPLATES  ]]===== -->
  <!-- =====[[ /TEMPLATES  ]]===== -->	
</xsl:stylesheet>


