<%@ page info="Gestione Contatti" %>
<%@ page contentType="text/html" %>
<%@ page session="false" %>
<%@ page buffer="20kb" %>
<%@ page errorPage="/ErrorPage.jsp" %>

<%@ page import="services.sessionservice.*" %>

<%@ taglib prefix="x" uri="http://java.sun.com/jstl/xml" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jstl/core" %>

<jsp:useBean id="contactManagement" scope="page" class="bflows.ContactManagement" />
<jsp:setProperty name="contactManagement" property="*" />

<%int i;

  Cookie[] cookies=null;
  cookies=request.getCookies();
  contactManagement.setUserCode(Session.getUserCode(cookies));
      
  String status;
  if (request.getParameter("status")==null)
    status="view";
  else
    status=request.getParameter("status");

  String message=null;
  
  if (status.equals("insert"))
    contactManagement.contactManagementInsert();

  if (status.equals("delete"))
    contactManagement.contactManagementDelete();

  contactManagement.contactManagementView();

  if (contactManagement.getResult()==-1){    
    throw new Exception("Errore nell'applicazione: consultare i logs.");
  } else if (contactManagement.getResult()==-2) {
    message=contactManagement.getErrorMessage();
  }

%>

<c:set var="xmlDocument" scope="page">

<ROOT>

  <%-- =====[[ INITIALS ]]===== --%>

  <INITIALS>
    <INITIAL SELECTED="<%=(contactManagement.getSelectedInitial()==null || contactManagement.getSelectedInitial().equals("*"))?"S":"N"%>">*</INITIAL>
<%for (i=0;i<contactManagement.getInitials().length;i++) { %>
    <INITIAL SELECTED="<%=(contactManagement.getSelectedInitial()!=null && (contactManagement.getInitials(i)).equals(contactManagement.getSelectedInitial()))?"S":"N"%>" 
    ><%=contactManagement.getInitials(i)%></INITIAL>  
<%}%>
  </INITIALS>
  <%-- =====[[ /INITIALS  ]]===== --%>

  <%-- =====[[ CONTACTS ]]===== --%>

<%for (i=0;i<contactManagement.getContacts().length;i++) { %>
  <CONTACTS>
    <CONTACT CODE="<%=(contactManagement.getContacts(i)).contactCode%>">
      <FIRSTNAME><%=(contactManagement.getContacts(i)).firstname %></FIRSTNAME>
      <SURNAME><%=(contactManagement.getContacts(i)).surname %></SURNAME>
      <SEX><%= (contactManagement.getContacts(i)).sex %></SEX>
      <ADDRESS><%= (contactManagement.getContacts(i)).address %></ADDRESS>
      <CITY><%= (contactManagement.getContacts(i)).city %></CITY>
      <PHONE><%= (contactManagement.getContacts(i)).phone %></PHONE>            
      <EMAIL><%=(contactManagement.getContacts(i)).email %></EMAIL>      
    </CONTACT>
  </CONTACTS>
<%}%>

  <%-- =====[[ /CONTACTS  ]]===== --%>

  <FLOW>

    <form name="changeInitialForm" method="post" action="AddressBookView.jsp">
      <input type="hidden" name="selectedInitial"/>
      <input type="hidden" name="status" value="view"/>      
    </form>    

    <form name="insertForm" method="post" action="AddressBookInsert.jsp">
      <input type="hidden" name="selectedInitial" value="<%=contactManagement.getSelectedInitial()%>"/>
      <input type="hidden" name="status" value="view"/>     
    </form>     

    <form name="modifyForm" method="post" action="AddressBookModify.jsp">     
      <input type="hidden" name="contactCode"/>
      <input type="hidden" name="firstname"/>
      <input type="hidden" name="surname"/>
      <input type="hidden" name="sex"/>
      <input type="hidden" name="address"/>
      <input type="hidden" name="city"/>
      <input type="hidden" name="phone"/>
      <input type="hidden" name="email"/>                  

      <input type="hidden" name="selectedInitial" value="<%=contactManagement.getSelectedInitial()%>"/>    
      <input type="hidden" name="status" value="view"/>
    </form>       

    <form name="deleteForm" method="post" action="AddressBookView.jsp">     
      <input type="hidden" name="contactCode"/>      
      <input type="hidden" name="selectedInitial" value="<%=contactManagement.getSelectedInitial()%>"/>    
  
      <input type="hidden" name="status" value="delete"/>
    </form>       

  </FLOW>

  <VAR>
    <ALERTMSG ENABLED="<%=(message!=null)?"S":"N"%>"><%=message!=null?message:""%></ALERTMSG>
  </VAR>
   
</ROOT>

</c:set>

<c:import var="xslDocument" url="/XSL/ITA/AddressBookView.xsl" scope="page"/>
<x:parse xml="${xmlDocument}" var="xml"/>
<x:parse xml="${xslDocument}" var="xsl"/>

<x:transform xml="${xml}" xslt="${xsl}"/>