<%@ page info="Home Page" %>
<%@ page contentType="text/html" %>
<%@ page session="false" %>
<%@ page buffer="30kb" %>
<%@ page errorPage="/ErrorPage.jsp" %>

<%@ page import="services.sessionservice.*" %>

<jsp:useBean id="logonManagement" scope="page" class="bflows.LogonManagement" />
<jsp:setProperty name="logonManagement" property="*" />

<%Cookie[] cookies=null;
  cookies=request.getCookies();
  
  boolean loggedOn=(cookies!=null);
  
  int i;
  String message=null;
  String status;

  status=request.getParameter("status");
  if (status==null) status="view";

  util.Debug.println("status: "+status);

  if (status.equals("logon")) {
    logonManagement.logon();    
    if (logonManagement.getCookies()!=null) {
      for(i=0;i<logonManagement.getCookies().length;i++)
        response.addCookie(logonManagement.getCookies(i));
      cookies=logonManagement.getCookies();
      loggedOn=true;      
    }
  }

  if (status.equals("logout")) {
    if (loggedOn) {
      logonManagement.setCookies(cookies);
      logonManagement.logout();    
      for(i=0;i<logonManagement.getCookies().length;i++)
        response.addCookie(logonManagement.getCookies(i));
      loggedOn=false;
    }
  }
  
  if (logonManagement.getResult()==-1){    
    throw new Exception("Errore nell'applicazione: consultare i logs.");
  } else if (logonManagement.getResult()==-2) {
    message=logonManagement.getErrorMessage();
  }

%>

<html>

  <head>
    <title>Rubrica - Logon</title>
    <meta name="author" content="Mario Zambrini"/>

    <link href="addressbook.css" rel="stylesheet" type="text/css"/>
    
    <script language="javascript">

      function isEmpty(value) {

        if (value == null || value.length == 0)
          return true;
        for (var count = 0; count < value.length; count++) {
          if (value.charAt(count) != " ") return false;
        }
        return true;

      }                

      function submitLogon() {

        if (isEmpty(logonForm.userCode.value)) {
          alert("Inserire uno username.");
          return;
        }        

        if (isEmpty(logonForm.password.value)) {
          alert("Inserire una password.");
          return;
        }      

        logonForm.submit();

      }

    </script>
  </head>

  <body bgcolor="#FFFFFF" text="#000000">

    <span class="pageTitle">Rubrica</span>   
    <br/><br/>

    <span class="pageSubtitle">Logon</span>   
    <br/><br/>

    <form name="logonForm" action="home.jsp" method="post">

      <table border="0">
        <tr>
          <td class="normal" width="100">Username</td>
          <td width="250">
            <input type="text" name="userCode" size="20" maxlength="50"/>
          </td>
        </tr>
        <tr>
          <td class="normal" width="100">Password</td>
          <td width="250">
            <input type="password" name="password" size="20" maxlength="50"/>
          </td>
        </tr>
      </table>
      <input type="hidden" name="status" value="logon"/>     
      <input type="button" value="Ok" onClick="submitLogon()"/>
    </form>

    <%if (loggedOn) {%>
      Benvenuto <%=Session.getUserFirstname(cookies)%> <%=Session.getUserSurname(cookies)%>!<br/>
      Accedi alla <a href="AddressBookView.jsp">Rubrica</a> 
      <form name="logoutForm" action="home.jsp" method="post">
        <input type="hidden" name="status" value="logout"/>
      </form>
      <a href="javascript:logoutForm.submit()">Logout</a>
    <%}%>					        

    <%if (message!=null) {%>
      <script>alert("<%=message%>");</script>
    <%}%>

  </body>

</html>
