
package bflows;

import java.util.*;
import java.beans.*;

import services.databaseservice.*;
import services.databaseservice.exception.*;
import services.errorservice.*;
import blogics.*;

/**
 *
 * @author  Mario Zambrini
 *
 */
public class ContactManagement implements java.io.Serializable{
    
  /** Holds value of property result. */
  private int result;
  
  /** Holds value of property errorMessage. */
  private String errorMessage;
  
  /** Holds value of property userCode. */
  private String userCode;
  
  /** Holds value of property contacts. */
  private Contact[] contacts;
  
  /** Holds value of property selectedInitial. */
  private String selectedInitial;
  
  /** Holds value of property initials. */
  private String[] initials;
  
  /** Holds value of property firstname. */
  private String firstname;
  
  /** Holds value of property surname. */
  private String surname;
  
  /** Holds value of property sex. */
  private String sex;
  
  /** Holds value of property address. */
  private String address;
  
  /** Holds value of property city. */
  private String city;
  
  /** Holds value of property phone. */
  private String phone;
  
  /** Holds value of property email. */
  private String email;
  
  /** Holds value of property contactCode. */
  private Long contactCode;
  
  /** Holds value of property contact. */
  private Contact contact;
    
  public ContactManagement() {}
    
  public void contactManagementView() {
    
    DataBase database = null;
    Vector vInitials=new Vector();
    Vector vContacts=new Vector();
    int i;
    
    try {
      
      database=DBService.getDataBase();
      
      vInitials=ContactService.getInitials(database,userCode);
      initials=new String[vInitials.size()];
      vInitials.copyInto(initials);            
      
      if ( selectedInitial==null ) selectedInitial="*";
      
      vContacts=ContactService.getContacts(database,userCode,
        (selectedInitial.equals("*")?null:selectedInitial),null);      
      contacts=new Contact[vContacts.size()];
      vContacts.copyInto(contacts);
      
      database.commit();
      
    } catch (NotFoundDBException ex) {
      
      EService.logAndRecover(ex);
      setResult(EService.UNRECOVERABLE_ERROR);
      
    } catch (ResultSetDBException ex) {
      
      EService.logAndRecover(ex);
      setResult(EService.UNRECOVERABLE_ERROR);
      
    } finally {
      try { database.close(); }
      catch (NotFoundDBException e) { EService.logAndRecover(e); }
    }
    
  }

  public void contactManagementInsert() {
    
    DataBase database = null;    
    Contact contact;
    
    try {
      
      database=DBService.getDataBase();
      
      contact=ContactService.insertNewContact(database,userCode,
                            firstname,surname,sex,
                            address,city,phone,email);            
      
      database.commit();
            
    } catch (NotFoundDBException ex) {
      
      EService.logAndRecover(ex);
      setResult(EService.UNRECOVERABLE_ERROR);
      database.rollBack();
      
    } catch (ResultSetDBException ex) {
      
      EService.logAndRecover(ex);
      setResult(EService.UNRECOVERABLE_ERROR);
      database.rollBack();
      
    } catch (DuplicatedRecordDBException ex) {
      
      EService.logAndRecover(ex);
      setResult(EService.RECOVERABLE_ERROR);
      setErrorMessage("Il contatto inserito e gia' esistente.");
      database.rollBack();  
      
    } finally {
      try { database.close(); }
      catch (NotFoundDBException e) { EService.logAndRecover(e); }
    }
    
  }
  
  public void contactManagementModify() {
    
    DataBase database=null;    
    
    try {
      
      database=DBService.getDataBase();
      
      contact=ContactService.getContact(database,contactCode,userCode);
            
      contact.firstname=firstname;
      contact.surname=surname;
      contact.sex=sex;      
      contact.address=address;
      contact.city=city;
      contact.phone=phone;
      contact.email=email;
                  
      contact.update(database);
      
      database.commit();
      
    } catch (NotFoundDBException ex) {
      
      EService.logAndRecover(ex);
      setResult(EService.UNRECOVERABLE_ERROR);
      database.rollBack();
      
    } catch (ResultSetDBException ex) {
      
      EService.logAndRecover(ex);
      setResult(EService.UNRECOVERABLE_ERROR);
      database.rollBack();
      
    } catch (DuplicatedRecordDBException ex) {
      
      EService.logAndRecover(ex);
      setResult(EService.RECOVERABLE_ERROR);
      setErrorMessage("Il contatto inserito e gia' esistente.");
      database.rollBack();  
            
    } finally {
      try { database.close(); }
      catch (NotFoundDBException e) { EService.logAndRecover(e); }
    }
    
  }   
  
  public void contactManagementDelete() {
    
    DataBase database = null;
    Contact contact;
    
    try {
      
      database=DBService.getDataBase();
            
      contact=ContactService.getContact(database,contactCode,userCode);
      contact.delete(database);
      
      database.commit();
      
    } catch (NotFoundDBException ex) {
      
      EService.logAndRecover(ex);
      setResult(EService.UNRECOVERABLE_ERROR);
      database.rollBack();
      
    } catch (ResultSetDBException ex) {
      
      EService.logAndRecover(ex);
      setResult(EService.UNRECOVERABLE_ERROR);
      database.rollBack();      
      
    } finally {
      try { database.close(); }
      catch (NotFoundDBException e) { EService.logAndRecover(e); }
    }
    
  }

  

  /** Getter for property result.
   * @return Value of property result.
   */
  public int getResult() {
    return this.result;
  }
  
  /** Setter for property result.
   * @param result New value of property result.
   */
  public void setResult(int result) {
    this.result = result;
  }
  
  /** Getter for property errorMessage.
   * @return Value of property errorMessage.
   */
  public String getErrorMessage() {
    return this.errorMessage;
  }
  
  /** Setter for property errorMessage.
   * @param errorMessage New value of property errorMessage.
   */
  public void setErrorMessage(String errorMessage) {
    this.errorMessage = errorMessage;
  }
  
  /** Getter for property userCode.
   * @return Value of property userCode.
   */
  public String getUserCode() {
    return this.userCode;
  }
  
  /** Setter for property userCode.
   * @param userCode New value of property userCode.
   */
  public void setUserCode(String userCode) {
    this.userCode = userCode;
  }
  
  /** Indexed getter for property contacts.
   * @param index Index of the property.
   * @return Value of the property at <CODE>index</CODE>.
   */
  public Contact getContacts(int index) {
    return this.contacts[index];
  }
  
  /** Getter for property contacts.
   * @return Value of property contacts.
   */
  public Contact[] getContacts() {
    return this.contacts;
  }
  
  /** Indexed setter for property contacts.
   * @param index Index of the property.
   * @param contacts New value of the property at <CODE>index</CODE>.
   */
  public void setContacts(int index, Contact contacts) {
    this.contacts[index] = contacts;
  }
  
  /** Setter for property contacts.
   * @param contacts New value of property contacts.
   */
  public void setContacts(Contact[] contacts) {
    this.contacts = contacts;
  }
  
  /** Getter for property selectedInitial.
   * @return Value of property selectedInitial.
   */
  public String getSelectedInitial() {
    return this.selectedInitial;
  }
  
  /** Setter for property selectedInitial.
   * @param selectedInitial New value of property selectedInitial.
   */
  public void setSelectedInitial(String selectedInitial) {
    this.selectedInitial = selectedInitial;
  }
  
  /** Indexed getter for property initials.
   * @param index Index of the property.
   * @return Value of the property at <CODE>index</CODE>.
   */
  public String getInitials(int index) {
    return this.initials[index];
  }
  
  /** Getter for property initials.
   * @return Value of property initials.
   */
  public String[] getInitials() {
    return this.initials;
  }
  
  /** Indexed setter for property initials.
   * @param index Index of the property.
   * @param initials New value of the property at <CODE>index</CODE>.
   */
  public void setInitials(int index, String initials) {
    this.initials[index] = initials;
  }
  
  /** Setter for property initials.
   * @param initials New value of property initials.
   */
  public void setInitials(String[] initials) {
    this.initials = initials;
  }
  
  /** Getter for property firstname.
   * @return Value of property firstname.
   */
  public String getFirstname() {
    return this.firstname;
  }
  
  /** Setter for property firstname.
   * @param firstname New value of property firstname.
   */
  public void setFirstname(String firstname) {
    this.firstname = firstname;
  }
  
  /** Getter for property surname.
   * @return Value of property surname.
   */
  public String getSurname() {
    return this.surname;
  }
  
  /** Setter for property surname.
   * @param surname New value of property surname.
   */
  public void setSurname(String surname) {
    this.surname = surname;
  }
  
  /** Getter for property sex.
   * @return Value of property sex.
   */
  public String getSex() {
    return this.sex;
  }
  
  /** Setter for property sex.
   * @param sex New value of property sex.
   */
  public void setSex(String sex) {
    this.sex = sex;
  }
  
  /** Getter for property address.
   * @return Value of property address.
   */
  public String getAddress() {
    return this.address;
  }
  
  /** Setter for property address.
   * @param address New value of property address.
   */
  public void setAddress(String address) {
    this.address = address;
  }
  
  /** Getter for property city.
   * @return Value of property city.
   */
  public String getCity() {
    return this.city;
  }
  
  /** Setter for property city.
   * @param city New value of property city.
   */
  public void setCity(String city) {
    this.city = city;
  }
  
  /** Getter for property phone.
   * @return Value of property phone.
   */
  public String getPhone() {
    return this.phone;
  }
  
  /** Setter for property phone.
   * @param phone New value of property phone.
   */
  public void setPhone(String phone) {
    this.phone = phone;
  }
  
  /** Getter for property email.
   * @return Value of property email.
   */
  public String getEmail() {
    return this.email;
  }
  
  /** Setter for property email.
   * @param email New value of property email.
   */
  public void setEmail(String email) {
    this.email = email;
  }
  
  /** Getter for property contactCode.
   * @return Value of property contactCode.
   */
  public Long getContactCode() {
    return this.contactCode;
  }
  
  /** Setter for property contactCode.
   * @param contactCode New value of property contactCode.
   */
  public void setContactCode(Long contactCode) {
    this.contactCode = contactCode;
  }
  
  /** Getter for property contact.
   * @return Value of property contact.
   */
  public Contact getContact() {
    return this.contact;
  }
  
  /** Setter for property contact.
   * @param contact New value of property contact.
   */
  public void setContact(Contact contact) {
    this.contact = contact;
  }
  
}
