<%@ page info="Gestione Contatti" %>
<%@ page contentType="text/html" %>
<%@ page session="false" %>
<%@ page buffer="20kb" %>
<%@ page errorPage="/ErrorPage.jsp" %>

<%@ page import="services.sessionservice.*" %>

<jsp:useBean id="contactManagement" scope="page" class="bflows.ContactManagement" />
<jsp:setProperty name="contactManagement" property="*" />

<%int i;

  Cookie[] cookies=null;
  cookies=request.getCookies();
  contactManagement.setUserCode(Session.getUserCode(cookies));
      
  String status;
  if (request.getParameter("status")==null)
    status="view";
  else
    status=request.getParameter("status");

  String message=null;
  
  if (status.equals("insert"))
    contactManagement.contactManagementInsert();

  if (status.equals("delete"))
    contactManagement.contactManagementDelete();

  contactManagement.contactManagementView();

  if (contactManagement.getResult()==-1){    
    throw new Exception("Errore nell'applicazione: consultare i logs.");
  } else if (contactManagement.getResult()==-2) {
    message=contactManagement.getErrorMessage();
  }

%>

<html>
  <head>        
    <title>Rubrica</title>      
    <meta name="author" content="Mario Zambrini"/>
    <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1"/>

    <link href="addressbook.css" rel="stylesheet" type="text/css"/>     				

    <script language="javascript">

      function changeInitial(inital) {
        document.changeInitialForm.selectedInitial.value=inital;            
        document.changeInitialForm.submit();
        return;
      }          

      function insertContact() {                     
        document.insertForm.submit();
        return;
      }                  

      function modifyContact(index) {            
        f=document.forms["modifyForm"+index];    						
        f.submit();
        return;
      }

      function deleteContact(code) {
        document.deleteForm.contactCode.value=code;
        document.deleteForm.submit();
        return;
      }          			

    </script>
  </head>

  <body bgcolor="#FFFFFF" text="#000000">

    <span class="pageTitle">
      Rubrica: <%=contactManagement.getSelectedInitial()%>    
    </span>   
    <br/><br/>          

    <a href="javascript:insertContact();">Nuovo Contatto</a>
    <br/><br/>
  <%if ( contactManagement.getSelectedInitial().equals("*") ) { %>
      <span class="selectedInitial">*&#160;</span>
  <%} else {%>
      <a class="initial" href="javascript:changeInitial('*');">*&#160;</a>
  <%}%>      
    <%for (i=0;i<contactManagement.getInitials().length;i++) { 
        if ( contactManagement.getInitials(i).equals(contactManagement.getSelectedInitial()) ) { %>
           <span class="selectedInitial"><%=contactManagement.getInitials(i)%>&#160;</span>
      <%} else {%>
          <a class="initial" href="javascript:changeInitial('<%=contactManagement.getInitials(i)%>');"><%=contactManagement.getInitials(i)%>&#160;</a>
      <%}%>  
    <%}%>
    <br/><br/>

  <%for (i=0;i<contactManagement.getContacts().length;i++) { %>  

      <form name="modifyForm<%=i%>" method="post" action="AddressBookModify.jsp">     
        <input type="hidden" name="contactCode" value="<%=(contactManagement.getContacts(i)).contactCode %>"/>
        <input type="hidden" name="firstname" value="<%=(contactManagement.getContacts(i)).firstname %>"/>
        <input type="hidden" name="surname" value="<%=(contactManagement.getContacts(i)).surname %>"/>
        <input type="hidden" name="sex" value="<%= (contactManagement.getContacts(i)).sex %>"/>
        <input type="hidden" name="address" value="<%= (contactManagement.getContacts(i)).address %>"/>
        <input type="hidden" name="city" value="<%= (contactManagement.getContacts(i)).city %>"/>
        <input type="hidden" name="phone" value="<%= (contactManagement.getContacts(i)).phone %>"/>
        <input type="hidden" name="email" value="<%= (contactManagement.getContacts(i)).email %>"/>                  

        <input type="hidden" name="selectedInitial" value="<%=contactManagement.getSelectedInitial()%>"/>    
        <input type="hidden" name="status" value="view"/>
      </form>           

      <table border="0">
        <tr>
          <td width="25" valign="top" align="center"><img src="images/ITA/ball.gif"/></td>
          <td class="name" width="*">        
            <a href="javascript:modifyContact(<%=i%>)">
              <%=(contactManagement.getContacts(i)).surname %>, <%=(contactManagement.getContacts(i)).firstname %>
            </a>
          </td>
          <td width="25" align="center"><a href="javascript:deleteContact(<%=(contactManagement.getContacts(i)).contactCode%>)"><img src="images/ITA/delete.gif" border="0"/></a></td>
        </tr>
        <tr>
          <td>&#160;</td>
          <td>
            <span class="phone"><%= (contactManagement.getContacts(i)).phone %></span>
            <address>
              <%= (contactManagement.getContacts(i)).address %><br/>
              <%= (contactManagement.getContacts(i)).city %><br/>          
            </address>
          </td>
          <td>&#160;</td>      
        </tr>
      </table>
  <%}%>


    <form name="changeInitialForm" method="post" action="AddressBookView.jsp">
      <input type="hidden" name="selectedInitial"/>
      <input type="hidden" name="status" value="view"/>      
    </form>    

    <form name="insertForm" method="post" action="AddressBookInsert.jsp">
      <input type="hidden" name="selectedInitial" value="<%=contactManagement.getSelectedInitial()%>"/>
      <input type="hidden" name="status" value="view"/>     
    </form>     

    <form name="deleteForm" method="post" action="AddressBookView.jsp">     
      <input type="hidden" name="contactCode"/>      
      <input type="hidden" name="selectedInitial" value="<%=contactManagement.getSelectedInitial()%>"/>    
  
      <input type="hidden" name="status" value="delete"/>
    </form>       

    <%if (message!=null) {%>
      <script>alert("<%=message%>");</script>
    <%}%>

  </body>
</html>
