<%@ page info="Modifica Contatto" %>
<%@ page contentType="text/html" %>
<%@ page session="false" %>
<%@ page buffer="20kb" %>
<%@ page errorPage="/ErrorPage.jsp" %>

<%@ page import="services.sessionservice.*" %>

<jsp:useBean id="contactManagement" scope="page" class="bflows.ContactManagement" />
<jsp:setProperty name="contactManagement" property="*" />

<%int i;

  Cookie[] cookies=null;
  cookies=request.getCookies();
  contactManagement.setUserCode(Session.getUserCode(cookies));
  
  String status;
  status=request.getParameter("status");

  String message=null;

  if (status.equals("modify"))
     contactManagement.contactManagementModify();    
    
  if (contactManagement.getResult()==-1){
    throw new Exception("Errore nell'applicazione: consultare i logs.");
  } else if (contactManagement.getResult()==-2) {
    message=contactManagement.getErrorMessage();
  }

%>

<html>
  <head>
    <title>Modifica Contatto</title>
    <meta name="author" content="Mario Zambrini"/>
    <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1"/>

    <link href="addressbook.css" rel="stylesheet" type="text/css"/>     				

    <script language="javascript">									

      function isEmpty(value) {

        if (value == null || value.length == 0)
          return true;
        for (var count = 0; count < value.length; count++) {
          if (value.charAt(count) != " ") return false;
        }
        return true;

      }                  

      function isValidEmail(s) {
        if (s.indexOf("@") > 0 && (s.indexOf("@") < (s.length - 1) ) ) return true;
        return false;
      }          

      function modifyContact() {

        f=document.modifyForm;

        //Nome
        if (isEmpty(f.firstname.value)) {
          alert("Inserire il nome.");
          return;
        }      

        //Cognome
        if (isEmpty(f.surname.value)) {
          alert("Inserire il cognome.");
          return;
        }    

        //Indirizzo
        if (isEmpty(f.address.value)) {
          alert("Inserire l'indirizzo.");
          return;
        }    

        //Citta'
        if (isEmpty(f.city.value)) {
          alert("Inserire la citta'.");
          return;
        }    

        //Telefono
        if (isEmpty(f.phone.value)) {
          alert("Inserire il telefono.");
          return;
        }    

        //E-Mail
        if (isEmpty(f.email.value) || !isValidEmail(f.email.value)) {
          alert("Inserire una e-mail corretta.");
          return;
        }   

        f.submit();
        return;

      }

    </script>
  </head>
  <body bgcolor="#FFFFFF" text="#000000">

    <span class="pageTitle">Rubrica</span>   
    <br/><br/>

    <span class="pageSubtitle">Modifica Contatto</span>
    <br/><br/>      			

    <form name="modifyForm" action="AddressBookModify.jsp" method="post">

      <table border="0">
        <tr>
          <td class="normal" width="100">Nome</td>
          <td width="250">
            <input type="text" name="firstname" value="<%=request.getParameter("firstname")%>" size="20" maxlength="50"/>
          </td>
        </tr>
        <tr>
          <td class="normal" width="100">Cognome</td>
          <td width="250">
            <input type="text" name="surname" value="<%=request.getParameter("surname")%>" size="20" maxlength="50"/>
          </td>
        </tr>
        <tr>
          <td class="normal" width="100">Sesso</td>
          <td width="250">
            <input type="radio" name="sex" value="M" <%=request.getParameter("sex").equals("M")?"checked=\"checked\"":""%>/>M
            <input type="radio" name="sex" value="F" <%=request.getParameter("sex").equals("F")?"checked=\"checked\"":""%>/>F				              
          </td>
        </tr>
        <tr>
          <td class="normal" width="100">Indirizzo</td>
          <td width="250">
            <input type="text" name="address" value="<%= request.getParameter("address")%>" size="20" maxlength="50"/>
          </td>
        </tr>
        <tr>
          <td class="normal" width="100">Citt&#224;</td>
          <td width="250">
            <input type="text" name="city" value="<%= request.getParameter("city")%>" size="20" maxlength="50"/>
          </td>
        </tr>
        <tr>
          <td class="normal" width="100">Telefono</td>
          <td width="250">
            <input type="text" name="phone" value="<%= request.getParameter("phone")%>" size="20" maxlength="50"/>
          </td>
        </tr>
        <tr>
          <td class="normal" width="100">E-Mail</td>
          <td width="250">
            <input type="text" name="email" value="<%=request.getParameter("email")%>" size="20" maxlength="50"/>
          </td>
        </tr>             
        <tr>
          <td class="normal" width="100">&#160;</td>
          <td width="250">
            <input type="button" value="invia" onClick="modifyContact()"/>
            <input type="button" value="indietro" onClick="backForm.submit()"/>
          </td>
        </tr>
      </table>

      <input type="hidden" name="contactCode" value="<%=request.getParameter("contactCode")%>" />
      <input type="hidden" name="selectedInitial" value="<%=contactManagement.getSelectedInitial()%>"/>  
      <input type="hidden" name="status" value="modify" />
 
    </form>

    <form name="backForm" method="post" action="AddressBookView.jsp">
       <input type="hidden" name="selectedInitial" value="<%=contactManagement.getSelectedInitial()%>"/>  
       <input type="hidden" name="status" value="view"/>
    </form>

    <%if (message!=null) {%>
      <script>alert("<%=message%>");</script>
    <%}%>

  </body>
</html>