<?xml version="1.0" encoding="ISO8859-1"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:template match="/">
<xsl:output method="html" indent="no"/>

<html>
<head>
<script>

function modify(atomicNumber){
	formx=document.forms.submitForm; 
	dataform=document.forms["data"+atomicNumber];	


	formx.atomicName.value=dataform.atomicName.value;
	formx.symbol.value=dataform.symbol.value;
	formx.state.value=dataform.state.value;
	formx.atomicNumber.value=dataform.atomicN.value;
	formx.atomicWeight.value=dataform.atomicW.value;
	formx.boilingPoint.value=dataform.boiling.value;
	formx.meltingPoint.value=dataform.melting.value;
	
}


  function submitModify(form){
  	form.azione.value="MODIFY";
	alert("modifica");
  	form.submit();
  }
	
  function submitInsert(form){

  	form.azione.value="INSERT";
	alert("insert")
  	form.submit();
  }



</script>


</head>


<body>

<h1>Tavola Periodica </h1>

<xsl:apply-templates select="/ROOT/PERIODIC_TABLE" />
<xsl:apply-templates select="/ROOT/ERROR" />

</body>


</html>
</xsl:template>



<xsl:template match="/ROOT/PERIODIC_TABLE" >
<h2>Lista degli elementi memorizzati </h2>
<table border="1" width="70%">
<tr>
<td> Numero Atomico </td>
<td> Simbolo </td>
<td> Nome</td>
</tr>
<xsl:apply-templates />
</table>

<hr/>

<h2> Dettaglio dell'elemento </h2>

<form name="submitForm" action="periodicTable.jsp" method="post">
<table border="1" width="70%">
<tr>
<td>Nome</td>
<td><input type="text" name="atomicName" /></td>
</tr>
<tr>
<td>Symbolo</td>
<td><input type="text" name="symbol" /></td>
</tr>
<tr>
<td> Stato a 0</td>
<td> <select name="state" >
		<option value="GAS"> gassoso</option>
		<option value="SOLID"> solido </option>
		<option value="LIQUID"> liquido</option>
         </select>
</td>
</tr>
<tr>
<td>Numero Atomico</td>
<td><input type="text" name="atomicNumber" /></td>
</tr>
<tr>
<td>Peso Atomico</td>
<td><input type="text" name="atomicWeight" /></td>
</tr>
<tr>
<td>Punto di ebollizione (Kelvin)</td>
<td><input type="text" name="boilingPoint" /></td>
</tr>
<tr>
<td>Punto di Fusione (Kelvin) </td>
<td><input type="text" name="meltingPoint" /></td>
</tr>
</table>



<input type="button" onclick="submitInsert(this.form)" value="Inserisci"> </input>
<input type="button" onclick="submitModify(this.form)" value="Modifica"> </input>


<input type="hidden" name="azione" value="VIEW"></input>
</form>
</xsl:template>


<xsl:template match="ATOM">
<tr>
	<td> <xsl:value-of select="ATOMIC_NUMBER" /></td>
	<td> <xsl:value-of select="SYMBOL" /></td>
	<td> <a href="javascript:modify({ATOMIC_NUMBER})"> <xsl:value-of select="NAME" /></a> </td>
</tr>
<!-- form hidden per la manipolazione in ajavascript -->
<form name="data{ATOMIC_NUMBER}">
<input type="hidden" name="atomicName" value="{NAME}" />
<input type="hidden" name="state" value="{@STATE}" />
<input type="hidden" name="symbol" value="{SYMBOL}" />
<input type="hidden" name="atomicN" value="{ATOMIC_NUMBER}" />
<input type="hidden" name="atomicW" value="{ATOMIC_WEIGHT}" />
<input type="hidden" name="boiling" value="{BOILING_POINT}" />
<input type="hidden" name="melting" value="{MELTING_POINT}" />
</form>


</xsl:template>


<xsl:template match="/ROOT/ERROR">
<script >
alert("{.}");
</script>


</xsl:template>

</xsl:stylesheet> 

