<%@ page import="soluzione.*" %>

<jsp:useBean id="pageBean"  class="soluzione.pageBean" />
<jsp:setProperty name="pageBean" property="*" />

<%@ taglib prefix="x" uri="http://java.sun.com/jstl/xml" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jstl/core" %>

<%
String error=pageBean.applyAction();
soluzione.periodicTable pT=pageBean.getPeriodicTable();
%>


<%-- Genero la struttura XML --%>
<c:import var="xslDoc" url="periodicTable.xsl"/>
<x:transform  xslt ="${xslDoc}">

<ROOT>

<PERIODIC_TABLE>
<%
   int i;
   for (i=0;i<pT.nElements;i++){
       atom a=pT.getElementByIndex(i);
%>
   <ATOM STATE="<%= a.getState()%>">
      <NAME><%= a.getName()%></NAME>
      <SYMBOL><%= a.getSymbol()%></SYMBOL>
      <ATOMIC_NUMBER><%= a.getAtomicNumber()%></ATOMIC_NUMBER>
      <ATOMIC_WEIGHT><%= a.getAtomicWeight()%></ATOMIC_WEIGHT>
      <BOILING_POINT UNITS="Kelvin"><%= a.getBoilingPoint()%></BOILING_POINT>
      <MELTING_POINT UNITS="Kelvin"><%= a.getMeltingPoint()%></MELTING_POINT>
</ATOM>
<% } /* fine del ciclo for */ %> 

</PERIODIC_TABLE>

<%-- Gestisco una eventuale errore nell'applicazione delle azioni pagina precedente --%>
<% if (error!=null) { %>
    <ERROR> <%= error %> </ERROR>
<% } %>
</ROOT>
</x:transform>
