/*
 * atom.java
 *
 * Created on 9 giugno 2002, 10.36
 */

package soluzione;

/**
 *
 * @author  Administrator
 * @version 
 */
public class atom extends java.lang.Object {

    private String name;
    private String symbol;
    private String state;   // GAS LIQUID or SOLID
    private int atomicNumber=0;
    private float atomicWeight=0;
    private float boilingPoint=0;  // unit=KELVIN  
    private float meltingPoint=0;  // unit=KELVIN  
        
    
    public atom(){
        // costruttore di default per creare un atomo vuoto
    }
    
    /** Creates new atom */
    public atom(String nome,String symb, String stato, 
                int atomicN,float atomicW, 
                float boilingP, float meltingP) throws Exception {
                
                    
        // validazione dei Campi
                    
        if ((nome==null) || (symb.length()==0))
            throw new Exception("il nome dell'elemento non pu essere nullo");
            
        if ((symb==null) || (symb.length()==0))
            throw new Exception("il simbolo dell'elemento non pu essere nullo");
            
        if ((stato==null) || 
            (!(stato.equals("GAS")) &&
             !(stato.equals("LIQUID")) &&
             !(stato.equals("SOLID"))))
            throw new Exception("Stato dell'elemento "+ stato + " non valido");
    
        if(atomicN<=0)
            throw new Exception("Numero Atomico deve essere intero positivo:"  + atomicN );
        
        if(atomicW<=1)
            throw new Exception("Peso Atomico deve essere positivo, maggiore di 1:" + atomicW);

        if(boilingP<-273)
           throw new Exception("Il punto di ebollizione  espresso in kelvin");
        if(meltingP<-273)
           throw new Exception("Il punto di fusione  espresso in kelvin");
            
        name=nome;    
        symbol=symb;
        state=stato;      
        atomicNumber=atomicN;
        atomicWeight=atomicW;
        boilingPoint=boilingP;   
        meltingPoint=meltingP;   
    }

    
    public String getName(){
        return name;
    }
    
    public String getSymbol(){
        return symbol;
    }
    
    public String getState(){
        return state;
    }

    public int getAtomicNumber(){
        return atomicNumber;
    }

    public float getAtomicWeight(){
        return atomicWeight;
    }

    public float getBoilingPoint(){
        return boilingPoint;
    }

    public float getMeltingPoint(){
        return meltingPoint;
    }
    
    
    
    
}
