/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.lang.jstl.test;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import javax.servlet.jsp.JspException;
import org.apache.taglibs.standard.lang.jstl.Evaluator;

public class ParserTest {
    public static void runTests(DataInput pIn, PrintStream pOut) throws IOException {
        String str;
        while ((str = pIn.readLine()) != null) {
            if (str.startsWith("#") || "".equals(str.trim())) {
                pOut.println(str);
                continue;
            }
            pOut.println("Attribute value: " + str);
            try {
                String result = Evaluator.parseAndRender(str);
                pOut.println("Parses to: " + result);
            }
            catch (JspException exc) {
                pOut.println("Causes an error: " + exc.getMessage());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void runTests(File pInputFile, File pOutputFile) throws IOException {
        FileInputStream fin = null;
        FileOutputStream fout = null;
        try {
            block4: {
                fin = new FileInputStream(pInputFile);
                BufferedInputStream bin = new BufferedInputStream(fin);
                DataInputStream din = new DataInputStream(bin);
                try {
                    fout = new FileOutputStream(pOutputFile);
                    BufferedOutputStream bout = new BufferedOutputStream(fout);
                    PrintStream pout = new PrintStream(bout);
                    ParserTest.runTests(din, pout);
                    pout.flush();
                    Object var9_8 = null;
                    if (fout == null) break block4;
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    if (fout == null) throw throwable;
                    fout.close();
                    throw throwable;
                }
                fout.close();
            }
            Object var11_11 = null;
            if (fin == null) return;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            if (fin == null) throw throwable;
            fin.close();
            throw throwable;
        }
        fin.close();
    }

    public static boolean isDifferentFiles(DataInput pIn1, DataInput pIn2) throws IOException {
        String str2;
        String str1;
        do {
            str1 = pIn1.readLine();
            str2 = pIn2.readLine();
            if (str1 == null && str2 == null) {
                return false;
            }
            if (str1 != null && str2 != null) continue;
            return true;
        } while (str1.equals(str2));
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isDifferentFiles(File pFile1, File pFile2) throws IOException {
        boolean bl;
        FileInputStream fin1 = null;
        try {
            block4: {
                fin1 = new FileInputStream(pFile1);
                BufferedInputStream bin1 = new BufferedInputStream(fin1);
                DataInputStream din1 = new DataInputStream(bin1);
                FileInputStream fin2 = null;
                try {
                    fin2 = new FileInputStream(pFile2);
                    BufferedInputStream bin2 = new BufferedInputStream(fin2);
                    DataInputStream din2 = new DataInputStream(bin2);
                    bl = ParserTest.isDifferentFiles(din1, din2);
                    Object var10_9 = null;
                    if (fin2 == null) break block4;
                }
                catch (Throwable throwable) {
                    Object var10_10 = null;
                    if (fin2 == null) throw throwable;
                    fin2.close();
                    throw throwable;
                }
                fin2.close();
            }
            Object var12_11 = null;
            if (fin1 == null) return bl;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            if (fin1 == null) throw throwable;
            fin1.close();
            throw throwable;
        }
        fin1.close();
        return bl;
    }

    public static void main(String[] pArgs) throws IOException {
        if (pArgs.length != 2 && pArgs.length != 3) {
            ParserTest.usage();
            System.exit(1);
        }
        File in = new File(pArgs[0]);
        File out = new File(pArgs[1]);
        ParserTest.runTests(in, out);
        if (pArgs.length > 2) {
            File compare = new File(pArgs[2]);
            if (ParserTest.isDifferentFiles(out, compare)) {
                System.out.println("Test failure - output file " + out + " differs from expected output file " + compare);
            } else {
                System.out.println("tests passed");
            }
        }
    }

    static void usage() {
        System.err.println("usage: java org.apache.taglibs.standard.lang.jstl.test.ParserTest {input file} {output file} [{compare file}]");
    }
}

