/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.jsp.jstl.tlv;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.servlet.jsp.tagext.PageData;
import javax.servlet.jsp.tagext.TagLibraryValidator;
import javax.servlet.jsp.tagext.ValidationMessage;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ScriptFreeTLV
extends TagLibraryValidator {
    private boolean allowDeclarations = false;
    private boolean allowScriptlets = false;
    private boolean allowExpressions = false;
    private boolean allowRTExpressions = false;
    private SAXParserFactory factory = SAXParserFactory.newInstance();

    public ScriptFreeTLV() {
        this.factory.setValidating(false);
        this.factory.setNamespaceAware(true);
    }

    public void setInitParameters(Map initParms) {
        super.setInitParameters(initParms);
        String declarationsParm = (String)initParms.get("allowDeclarations");
        String scriptletsParm = (String)initParms.get("allowScriptlets");
        String expressionsParm = (String)initParms.get("allowExpressions");
        String rtExpressionsParm = (String)initParms.get("allowRTExpressions");
        this.allowDeclarations = "true".equalsIgnoreCase(declarationsParm);
        this.allowScriptlets = "true".equalsIgnoreCase(scriptletsParm);
        this.allowExpressions = "true".equalsIgnoreCase(expressionsParm);
        this.allowRTExpressions = "true".equalsIgnoreCase(rtExpressionsParm);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ValidationMessage[] validate(String prefix, String uri, PageData page) {
        SAXParser parser;
        InputStream in = null;
        MyContentHandler handler = new MyContentHandler();
        SAXParserFactory sAXParserFactory = this.factory;
        synchronized (sAXParserFactory) {
            parser = this.factory.newSAXParser();
        }
        in = page.getInputStream();
        parser.parse(in, (DefaultHandler)handler);
        Object var12_12 = null;
        if (in == null) return handler.reportResults();
        try {
            in.close();
            return handler.reportResults();
        }
        catch (IOException e2) {}
        return handler.reportResults();
        {
            catch (ParserConfigurationException e) {
                ValidationMessage[] validationMessageArray = ScriptFreeTLV.vmFromString(e.getMessage());
                Object var12_13 = null;
                if (in == null) return validationMessageArray;
                try {
                    in.close();
                    return validationMessageArray;
                }
                catch (IOException e2) {
                    // empty catch block
                }
                return validationMessageArray;
            }
            catch (SAXException e) {
                ValidationMessage[] validationMessageArray = ScriptFreeTLV.vmFromString(e.getMessage());
                Object var12_14 = null;
                if (in == null) return validationMessageArray;
                try {
                    in.close();
                    return validationMessageArray;
                }
                catch (IOException e2) {
                    // empty catch block
                }
                return validationMessageArray;
            }
            catch (IOException e) {
                ValidationMessage[] validationMessageArray = ScriptFreeTLV.vmFromString(e.getMessage());
                Object var12_15 = null;
                if (in == null) return validationMessageArray;
                try {
                    in.close();
                    return validationMessageArray;
                }
                catch (IOException e2) {
                    // empty catch block
                }
                return validationMessageArray;
            }
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private static ValidationMessage[] vmFromString(String message) {
        return new ValidationMessage[]{new ValidationMessage(null, message)};
    }

    private class MyContentHandler
    extends DefaultHandler {
        private int declarationCount = 0;
        private int scriptletCount = 0;
        private int expressionCount = 0;
        private int rtExpressionCount = 0;

        private MyContentHandler() {
        }

        public void startElement(String namespaceUri, String localName, String qualifiedName, Attributes atts) {
            if (!ScriptFreeTLV.this.allowDeclarations && qualifiedName.equals("jsp:declaration")) {
                ++this.declarationCount;
            } else if (!ScriptFreeTLV.this.allowScriptlets && qualifiedName.equals("jsp:scriptlet")) {
                ++this.scriptletCount;
            } else if (!ScriptFreeTLV.this.allowExpressions && qualifiedName.equals("jsp:expression")) {
                ++this.expressionCount;
            }
            if (!ScriptFreeTLV.this.allowRTExpressions) {
                this.countRTExpressions(atts);
            }
        }

        private void countRTExpressions(Attributes atts) {
            int stop = atts.getLength();
            int i = 0;
            while (i < stop) {
                String attval = atts.getValue(i);
                if (attval.startsWith("%=") && attval.endsWith("%")) {
                    ++this.rtExpressionCount;
                }
                ++i;
            }
        }

        public ValidationMessage[] reportResults() {
            if (this.declarationCount + this.scriptletCount + this.expressionCount + this.rtExpressionCount > 0) {
                StringBuffer results = new StringBuffer("JSP page contains ");
                boolean first = true;
                if (this.declarationCount > 0) {
                    results.append(Integer.toString(this.declarationCount));
                    results.append(" declaration");
                    if (this.declarationCount > 1) {
                        results.append('s');
                    }
                    first = false;
                }
                if (this.scriptletCount > 0) {
                    if (!first) {
                        results.append(", ");
                    }
                    results.append(Integer.toString(this.scriptletCount));
                    results.append(" scriptlet");
                    if (this.scriptletCount > 1) {
                        results.append('s');
                    }
                    first = false;
                }
                if (this.expressionCount > 0) {
                    if (!first) {
                        results.append(", ");
                    }
                    results.append(Integer.toString(this.expressionCount));
                    results.append(" expression");
                    if (this.expressionCount > 1) {
                        results.append('s');
                    }
                }
                if (this.rtExpressionCount > 0) {
                    if (!first) {
                        results.append(", ");
                    }
                    results.append(Integer.toString(this.rtExpressionCount));
                    results.append(" request-time attribute value");
                    if (this.rtExpressionCount > 1) {
                        results.append('s');
                    }
                }
                results.append(".");
                return ScriptFreeTLV.vmFromString(results.toString());
            }
            return null;
        }
    }
}

