/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.jsp.jstl.core;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.jstl.core.LoopTag;
import javax.servlet.jsp.jstl.core.LoopTagStatus;
import javax.servlet.jsp.jstl.core.LoopTagSupport;
import javax.servlet.jsp.tagext.IterationTag;
import javax.servlet.jsp.tagext.TagSupport;
import javax.servlet.jsp.tagext.TryCatchFinally;

public abstract class LoopTagSupport
extends TagSupport
implements LoopTag,
IterationTag,
TryCatchFinally {
    protected int begin;
    protected int end;
    protected int step;
    protected boolean beginSpecified;
    protected boolean endSpecified;
    protected boolean stepSpecified;
    protected String itemId;
    protected String statusId;
    private LoopTagStatus status;
    private Object item;
    private int index;
    private int count;
    private boolean last;

    public LoopTagSupport() {
        this.init();
    }

    protected abstract Object next() throws JspTagException;

    protected abstract boolean hasNext() throws JspTagException;

    protected abstract void prepare() throws JspTagException;

    public void release() {
        super.release();
        this.init();
    }

    public int doStartTag() throws JspException {
        if (this.end != -1 && this.begin > this.end) {
            throw new JspTagException("begin (" + this.begin + ") > end (" + this.end + ")");
        }
        this.index = 0;
        this.count = 1;
        this.last = false;
        this.prepare();
        this.discardIgnoreSubset(this.begin);
        if (!this.hasNext()) {
            return 0;
        }
        this.item = this.next();
        this.discard(this.step - 1);
        this.exposeVariables();
        this.calibrateLast();
        return 1;
    }

    public int doAfterBody() throws JspException {
        this.index += this.step - 1;
        ++this.count;
        if (this.hasNext() && !this.atEnd()) {
            ++this.index;
        } else {
            return 0;
        }
        this.item = this.next();
        this.discard(this.step - 1);
        this.exposeVariables();
        this.calibrateLast();
        return 2;
    }

    public void doFinally() {
        this.unExposeVariables();
    }

    public void doCatch(Throwable t) throws Throwable {
        throw t;
    }

    public Object getCurrent() {
        return this.item;
    }

    public LoopTagStatus getIteratorStatus() {
        if (this.status == null) {
            class Status
            implements LoopTagStatus {
                private final /* synthetic */ LoopTagSupport this$0;

                Status(LoopTagSupport this$0) {
                    this.this$0 = this$0;
                }

                public Object getCurrent() {
                    return this.this$0.getCurrent();
                }

                public int getIndex() {
                    return LoopTagSupport.access$000(this.this$0) + this.this$0.begin;
                }

                public int getCount() {
                    return LoopTagSupport.access$100(this.this$0);
                }

                public boolean isFirst() {
                    return LoopTagSupport.access$000(this.this$0) == 0;
                }

                public boolean isLast() {
                    return LoopTagSupport.access$200(this.this$0);
                }

                public Integer getBegin() {
                    if (this.this$0.beginSpecified) {
                        return new Integer(this.this$0.begin);
                    }
                    return null;
                }

                public Integer getEnd() {
                    if (this.this$0.endSpecified) {
                        return new Integer(this.this$0.end);
                    }
                    return null;
                }

                public Integer getStep() {
                    if (this.this$0.stepSpecified) {
                        return new Integer(this.this$0.step);
                    }
                    return null;
                }
            }
            this.status = new Status(this);
        }
        return this.status;
    }

    public void setVar(String id) {
        this.itemId = id;
    }

    public void setVarStatus(String statusId) {
        this.statusId = statusId;
    }

    protected void validateBegin() throws JspTagException {
        if (this.begin < 0) {
            throw new JspTagException("'begin' < 0");
        }
    }

    protected void validateEnd() throws JspTagException {
        if (this.end < 0) {
            throw new JspTagException("'end' < 0");
        }
    }

    protected void validateStep() throws JspTagException {
        if (this.step < 1) {
            throw new JspTagException("'step' <= 0");
        }
    }

    private void init() {
        this.index = 0;
        this.count = 1;
        this.status = null;
        this.item = null;
        this.last = false;
        this.beginSpecified = false;
        this.endSpecified = false;
        this.stepSpecified = false;
        this.begin = 0;
        this.end = -1;
        this.step = 1;
        this.itemId = null;
        this.statusId = null;
    }

    private void calibrateLast() throws JspTagException {
        this.last = !this.hasNext() || this.atEnd() || this.end != -1 && this.begin + this.index + this.step > this.end;
    }

    private void exposeVariables() throws JspTagException {
        if (this.itemId != null) {
            if (this.getCurrent() == null) {
                this.pageContext.removeAttribute(this.itemId, 1);
            } else {
                this.pageContext.setAttribute(this.itemId, this.getCurrent());
            }
        }
        if (this.statusId != null) {
            if (this.getIteratorStatus() == null) {
                this.pageContext.removeAttribute(this.statusId, 1);
            } else {
                this.pageContext.setAttribute(this.statusId, (Object)this.getIteratorStatus());
            }
        }
    }

    private void unExposeVariables() {
        if (this.itemId != null) {
            this.pageContext.removeAttribute(this.itemId, 1);
        }
        if (this.statusId != null) {
            this.pageContext.removeAttribute(this.statusId, 1);
        }
    }

    private void discard(int n) throws JspTagException {
        int oldIndex = this.index;
        while (n-- > 0 && !this.atEnd() && this.hasNext()) {
            ++this.index;
            this.next();
        }
        this.index = oldIndex;
    }

    private void discardIgnoreSubset(int n) throws JspTagException {
        while (n-- > 0 && this.hasNext()) {
            this.next();
        }
    }

    private boolean atEnd() {
        return this.end != -1 && this.begin + this.index >= this.end;
    }

    static /* synthetic */ int access$000(LoopTagSupport x0) {
        return x0.index;
    }

    static /* synthetic */ int access$100(LoopTagSupport x0) {
        return x0.count;
    }

    static /* synthetic */ boolean access$200(LoopTagSupport x0) {
        return x0.last;
    }
}

