<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" indent="no"/>
	<xsl:template match="/">
		<html>
			<head>
				<title>ESEMPIO ALTERNANZA COLORI</title>
			</head>
			<body topmargin="0" leftmargin="0" marginheight="0" marginwidth="0" bgcolor="#FFFFFF">
			codici adiacenti uguali vengono raggruppati con il medesimo colore.
				<table border="1" cellspacing="0" cellpadding="0" bordercolor="#eeeeee">
					<xsl:apply-templates select="/ROOT/REPORT[1]">
						<xsl:with-param name="lastbgcolor" select="'#D3D1D1'"/>
					</xsl:apply-templates>
				</table>
			</body>
		</html>
	</xsl:template>
	
	<!-- =====[[ TEMPLATES  ]]===== -->
	<xsl:template match="REPORT">
		<xsl:param name="lastbgcolor">#eeeeee</xsl:param>
		<xsl:variable name="bgcolor">
			<xsl:choose>
				<xsl:when test="preceding-sibling::REPORT[1]/@CODE !=@CODE  and $lastbgcolor='#D3D1D1'">
					<xsl:text>#eeeeee</xsl:text>
				</xsl:when>
				<xsl:when test="preceding-sibling::REPORT[1]/@CODE !=@CODE  and $lastbgcolor='#eeeeee'">
					<xsl:text>#D3D1D1</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$lastbgcolor"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<tr bgcolor="{$bgcolor}">
			<td>
				<xsl:value-of select="."/>(<xsl:value-of select="@CODE"/>)
			</td>
		</tr>
		<xsl:apply-templates select="following-sibling::REPORT[1]">
			<xsl:with-param name="lastbgcolor">
				<xsl:value-of select="$bgcolor"/>
			</xsl:with-param>
		</xsl:apply-templates>
	</xsl:template>

	<!-- =====[[ /TEMPLATES  ]]===== -->
</xsl:stylesheet>
