<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html"/>
	<xsl:template match="/">
		<html>
			<body>
				<h3>Team Members</h3>
				<ul>
					<xsl:for-each select="team/manager|team/programmer">
						<xsl:sort select="name"/>
						<li>
							<xsl:value-of select="name"/>
							<xsl:text>, ssn = </xsl:text>
							<xsl:call-template name="formatSSN">
								<xsl:with-param name="ssn" select="@ssn"/>
							</xsl:call-template>
						</li>
					</xsl:for-each>
				</ul>
			</body>
		</html>
	</xsl:template>
	<!-- a named template that formats a 9 digit SSN
	     by inserting '-' characters -->
	<xsl:template name="formatSSN">
		<xsl:param name="ssn" select="'000000000'"/>
		<xsl:value-of select="substring($ssn, 1, 3)"/>
		<xsl:text>-</xsl:text>
		<xsl:value-of select="substring($ssn, 4, 2)"/>
		<xsl:text>-</xsl:text>
		<xsl:value-of select="substring($ssn, 6)"/>
	</xsl:template>
</xsl:stylesheet>
