<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html"/>
	
	<xsl:variable name="firstName" select="'John'"/>
	<xsl:variable name="lastName" select="'Kennedy'"/>
	<xsl:variable name="middleName" select="'F.'"/>
	<xsl:variable name="fullName" 
				select="concat($firstName, ' ', $middleName, ' ', $lastName)"/>
	
	<xsl:template match="/">

		<h2>String Functions</h2>
		<table border="1" cellpadding="4">
			<tr>
				<th>Function</th>
				<th>Example</th>
				<th>Output</th>
			</tr>
			<tr>
				<td>string concat(string,string,string*)</td>
				<td>concat($firstName, ' ', $lastName)</td>
				<td><xsl:value-of select="concat($firstName, ' ', $lastName)"/></td>
			</tr>
			<tr>
				<td>boolean starts-with(string,string)</td>
				<td>starts-with($firstName, 'Er')</td>
				<td><xsl:value-of select="starts-with($firstName, 'Er')"/></td>
			</tr>
			<tr>
				<td>boolean contains(string,string)</td>
				<td>contains($fullName, 'Smith')</td>
				<td><xsl:value-of select="contains($fullName, 'Smith')"/></td>
			</tr>
			<tr>
				<td>string substring-before(string,string)</td>
				<td>substring-before($fullName, ' ')</td>
				<td><xsl:value-of select="substring-before($fullName, ' ')"/></td>
			</tr>
			<tr>
				<td>string substring-after(string,string)</td>
				<td>substring-after($fullName, ' ')</td>
				<td><xsl:value-of select="substring-after($fullName, ' ')"/></td>
			</tr>
			<tr>
				<td>string substring(string,number,number?)</td>
				<td>substring($middleName,1,1)</td>
				<td><xsl:value-of select="substring($middleName,1,1)"/></td>
			</tr>
			<tr>
				<td>number string-length(string?)</td>
				<td>string-length($fullName)</td>
				<td><xsl:value-of select="string-length($fullName)"/></td>
			</tr>
			<tr>
				<td>string normalize-space(string?)</td>
				<td>normalize-space('  testing  ')</td>
				<td><xsl:value-of select="normalize-space('  testing  ')"/></td>
			</tr>
			<tr>
				<td>string translate(string,string,string)</td>
				<td>translate($text,
				'abcdefghijklmnopqrstuvwxyz',
				'ABCDEFGHIJKLMNOPQRSTUVWXYZ')</td>
				<td><xsl:call-template name="toUpper">
							<xsl:with-param name="text" select="$fullName"/>
						</xsl:call-template></td>
			</tr>
		</table>
		
		<h3>Date Example</h3>
		<xsl:variable name="dateStr" select="//date"/>
		<xsl:variable name="dayYear" select="substring-after($dateStr, '/')"/>
		Month: <xsl:value-of select="substring-before($dateStr, '/')"/> <br/>
		Day: <xsl:value-of select="substring-before($dayYear, '/')"/> <br/>
		Year: <xsl:value-of select="substring-after($dayYear, '/')"/>
	</xsl:template>
	
	<xsl:template name="toUpper">
		<xsl:param name="text"/>
		<xsl:value-of select="translate($text,
				'abcdefghijklmnopqrstuvwxyz',
				'ABCDEFGHIJKLMNOPQRSTUVWXYZ')"/>
	</xsl:template>
</xsl:stylesheet>
