<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html"/>
	<xsl:template match="/">
		<html>
			<body>
				<!-- loop over each of the sample formats -->
				<xsl:for-each select="numberFormatting/formatSamples/format">
					<h2>
						<!-- show the format as a heading -->
						<xsl:value-of select="."/>
					</h2>
					<table border="1" cellpadding="2" cellspacing="0">
						<tr>
							<th>Number</th>
							<th>Result</th>
						</tr>
						
						<!-- pass the format as a parameter to the template that
						      shows each number -->
						<xsl:apply-templates select="/numberFormatting/numberSamples/number">
							<xsl:with-param name="fmt" select="."/>
						</xsl:apply-templates>
					</table>
				</xsl:for-each>
			</body>
		</html>
	</xsl:template>
	
	<!-- output the number followed by the result of the format-number function -->
	<xsl:template match="number">
		<xsl:param name="fmt"/>
		<tr>
			<td align="right">
				<xsl:value-of select="."/>
			</td>
			<td align="right">
				<!-- the first param is a dot, representing the text content
				     of the <number> element -->
				<xsl:value-of select="format-number(.,$fmt)"/>
			</td>
		</tr>
	</xsl:template>
</xsl:stylesheet>
