<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html"/>
	
	<!-- processing begins here -->
	<xsl:template match="/">
		<html>
			<body>
				<!-- select the top level person -->
				<xsl:apply-templates select="person">
					<xsl:with-param name="level">0</xsl:with-param>
				</xsl:apply-templates>
			</body>
		</html>
	</xsl:template>
	
	<!-- Output information for a person and recursively select
	     all children. -->
	<xsl:template match="person">
		<xsl:param name="level"/>
	
		<!-- indent according to the level -->
		<div style="text-indent:{$level}em">
			<xsl:value-of select="@name"/>
		</div>
	
		<!-- recursively select children, incrementing the level -->
		<xsl:apply-templates select="person">
			<xsl:with-param name="level" select="$level + 1"/>
		</xsl:apply-templates>
	</xsl:template>
</xsl:stylesheet>
