<?xml version="1.0" ?>

<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:template match="/">


		<html>
				<head>
				    <link href="style.css" rel="stylesheet" type="text/css"/>
				<script>
				
					function prenota(code) {
						
						document.formx.code.value=code;
						document.formx.submit();
					
					}
					
					function cancella(code) {
						
						document.formx.cmd.value="cancella";
						document.formx.code.value=code;
						document.formx.submit();
					
					}
					
					function aggiorna() {

						document.formx.cmd.value="refresh";
						document.formx.submit();
					
					}

					
					function viewmess(){
					
						mess = "<xsl:value-of select="//message"/>";
						if (mess!="") alert (mess);
					
					}
				</script>
				
		</head>
		
		<body onload="viewmess()">
			<a href="javascript:aggiorna()">REFRESH MAPPA</a>
			
			
			<table border="1">
				<xsl:apply-templates select="//row"/>   		
			</table>
			<form action="prenota.jsp" method="post" name="formx">
				<input type="hidden" name="cmd" value="prenota"/>
				<input type="hidden" name="code" value=""/>		
				<input type="hidden" name="nick" value="{//nick}"/>		
			</form>
		</body>
		</html>
</xsl:template>

<xsl:template match="row">
	<tr>	
		<xsl:apply-templates select="seat"/>
	</tr>
</xsl:template>

<xsl:template match="seat">
	<td>
		<xsl:choose>
			<xsl:when test="@active='yes' and @free='yes'"><input type="button" name="{@code}" value="free" onclick="prenota({@code})"/></xsl:when>
			<xsl:when test="@active='yes' and @free='no' and @owner=//nick"><input type="button" name="{@code}" value="cancel" onclick="cancella({@code})"/></xsl:when>
			<xsl:when test="@active='yes' and @free='no' ">reserved</xsl:when>
			<xsl:otherwise>-</xsl:otherwise>
		</xsl:choose>
	</td>
</xsl:template>


</xsl:stylesheet> 
