/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.fmt;

import java.io.UnsupportedEncodingException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.TagSupport;

public abstract class RequestEncodingSupport
extends TagSupport {
    static final String REQUEST_CHAR_SET = "javax.servlet.jsp.jstl.fmt.request.charset";
    private static final String DEFAULT_ENCODING = "ISO-8859-1";
    protected String value;

    public RequestEncodingSupport() {
        this.init();
    }

    private void init() {
        this.value = null;
    }

    public int doEndTag() throws JspException {
        if (this.value == null && this.pageContext.getRequest().getCharacterEncoding() == null) {
            this.value = (String)this.pageContext.getAttribute(REQUEST_CHAR_SET, 3);
            if (this.value == null) {
                this.value = DEFAULT_ENCODING;
            }
        }
        if (this.value != null) {
            try {
                this.pageContext.getRequest().setCharacterEncoding(this.value);
            }
            catch (UnsupportedEncodingException uee) {
                throw new JspTagException(uee.getMessage());
            }
        }
        return 6;
    }

    public void release() {
        this.init();
    }
}

