<?xml version="1.0" encoding="UTF-8" ?>

<!--  
  Document   : catalog.xsl 
  Created on : 17 luglio 2002 
  Author     : aravani
  Comment
    purpose of transformation follows.
-->

<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:fo="http://www.w3.org/1999/XSL/Format">


  <!-- template rule matching source root element -->
  <xsl:template match="/">

  
  <html>

	<head>

	<style>
		.testo { color:#003399; font-family:Arial; font-size:10px; font-weight:bold; text-decoration:none; }
	</style>
	
	<script language="javascript">
		var descrizioni 	= new Array(<xsl:apply-templates select="//product/description"/>'#');
		var brands 		= new Array (<xsl:apply-templates select="//product/brand"/>'#');
		var nomi 			= new Array (<xsl:apply-templates select="//product/name"/>'#');
		var prezzi 			= new Array (<xsl:apply-templates select="//product/@price"/>'#');
		var descrizioniestese = new Array (<xsl:apply-templates select="//product/extended_description"/>'#');
		
		var	euro 			= "<xsl:value-of select="//euro"/>";
				
		
		function previewdescr (i) {
			document.forms.preview.descr.value = descrizioni[i-1];
		}

		function previewbrand (i) {
			document.forms.preview.brand.value = brands[i-1];
		}
		
		function cleanpreview() {
			document.forms.preview.descr.value = "";
			document.forms.preview.brand.value = "";
		}
		
		function details(i) {
			oForm = parent.details.document.forms.dettaglio;
			
			oForm.nome.value	= 	nomi [i-1];
			oForm.descr.value	=	descrizioni [i-1];
			oForm.extdescr.value	=	descrizioniestese [i-1];
			oForm.prezzo.value	=	prezzi [i-1];
		}

	</script>
	

	
	
	</head>
    

    <body bgcolor="#eeeeee" class="testo">
        <h3>lista prodotti</h3><br/>

	<table border="1" cellpadding="0" cellspacing="0">
		<tr bgcolor="#ffffff">
			<td>code</td>
			<td>name</td>
			<td>price</td>
		</tr>
		<xsl:apply-templates select="//product"/>
	</table>

	<form name="preview">
		<input type="text" name="descr"/>
		<input type="text" name="brand"/>
	</form>
	
	<br/>
	<br/>
	il tuo credito è di <b><xsl:value-of select="//euro"/></b> euro

    </body>
	
  </html>
  
  
    </xsl:template>



<xsl:template match="product">
	<tr>
		<td align="center"><a  onmouseout="cleanpreview()"    onmouseover ="previewdescr({position()});previewbrand({position()});" href="javascript:details({position()})"><xsl:value-of select="@code"/></a></td>
		<td><xsl:value-of select="name"/></td>
		<td><xsl:value-of select="@price"/></td>
	</tr>
</xsl:template>
<xsl:template match="description|brand|name|@price|extended_description">
	"<xsl:value-of select="."/>",
</xsl:template>


</xsl:stylesheet> 