
// Copyright (c) 2000 Jakala
package customtag;


import java.util.ResourceBundle;
import javax.servlet.jsp.JspException;

import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import java.util.*;
import java.sql.*;
import java.io.*;



/**
 * A Class class.
 * <P>
 * @author Jakala Tech Krew
 */
public class logBodyContent extends BodyTagSupport {

    private String filename="log.xml";    
    private boolean timestamp=false;
    private boolean write=true ;

    private PrintWriter oFile;

	public void setFilename(String value){
		filename = value;
	}

	public String getFilename(){
		return(filename);
	}

	public void setTimestamp(boolean value){
		timestamp = value;
	}
  
	public void setTimestamp(String value){
		timestamp = value.equals("true");
	}  

	public boolean getTimestamp(){
		return timestamp;
	}

	public void setWrite(boolean value){
		write = value ;
	}
  
	public void setWrite(String value){
		write = value.equals("true") ;
	}  

	public boolean getWrite(){
		return write;
	}

  public int doStartTag() throws JspTagException{
    
    try {

        if (!write) return EVAL_BODY_TAG;
        StringBuffer newName = new StringBuffer(filename);
        if (timestamp) {
            if (filename.lastIndexOf(".") == -1) filename=filename+".xml";
            int position = filename.lastIndexOf(".");
            newName.replace(position,position+1,"_"+System.currentTimeMillis()+".");
        }

        oFile = new PrintWriter(new FileWriter(newName.toString()));
        oFile.println("<!--=====[[ begin xml ]]=====-->");

    } catch (Exception ex) {
      throw new JspTagException(">:" + ex );
    }
    // Evaluate the body if there is one
    return EVAL_BODY_TAG;
  }

  public int doEndTag()throws JspTagException {

    if (!write) return EVAL_PAGE;
    try {
      oFile.println("<!--=====[[ end xml ]]=====-->");
      oFile.close();
    } catch (Exception ex){
     throw new JspTagException(">:" + ex);
    }
    return EVAL_PAGE;
    
  }

	public int doAfterBody() throws JspTagException {

    BodyContent body = getBodyContent();
      try {
		// Make sure we put anything in the output stream in the
		// body to the output stream of the JSP
        JspWriter out = body.getEnclosingWriter();
        out.println(body.getString());
        if (write) oFile.println(body.getString());
        body.clearBody(); // Clear for next evaluation
      } catch(Exception ioe) {
        throw new JspTagException("Error in logBodyContent tag doAfterBody: " + ioe);
      }

      return(SKIP_BODY);
	}

  public void release() {
      filename="log.xml";  
      timestamp=false;
      write=true ;      
      oFile = null;
      super.release();
  }

}
