/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLParseException;

public class oraxml {
    private OutputStream errors = System.err;
    private static final String newline = System.getProperty("line.separator");
    private static final String usageMessage = "usage: oraxml options* source" + newline + "            -v                          Validation mode" + newline + "            -w                          Show warnings" + newline + "            -debug                      Debug mode" + newline + "            -e <error log>              A file to write errors to" + newline;

    private URL createURL(String string) throws Exception {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(string);
            try {
                String string2 = file.getAbsolutePath();
                String string3 = System.getProperty("file.separator");
                if (string3.length() == 1) {
                    char c = string3.charAt(0);
                    if (c != '/') {
                        string2 = string2.replace(c, '/');
                    }
                    if (string2.charAt(0) != '/') {
                        string2 = String.valueOf('/') + string2;
                    }
                }
                string2 = "file://" + string2;
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException2) {
                this.exitWithError("Cannot create url for: " + string + "(" + malformedURLException2.getMessage() + ")");
            }
        }
        return uRL;
    }

    private void exitWithError(String string) {
        PrintWriter printWriter = new PrintWriter(this.errors);
        printWriter.println(string);
        printWriter.flush();
        System.exit(1);
    }

    private boolean isFlag(String string) {
        return string.charAt(0) == '-';
    }

    public static void main(String[] stringArray) {
        oraxml oraxml2 = new oraxml();
        oraxml2.process(stringArray);
    }

    private void printUsage(String string) {
        System.out.println(String.valueOf(string) + newline + usageMessage);
    }

    void process(String[] stringArray) {
        DOMParser dOMParser = new DOMParser();
        URL uRL = null;
        int n = stringArray.length;
        String string = null;
        String string2 = null;
        if (n == 0) {
            this.printUsage("");
            System.exit(0);
        }
        int n2 = 0;
        while (n2 < n) {
            string = stringArray[n2];
            if (string.charAt(0) != '-') break;
            switch (string.charAt(1)) {
                case 'h': {
                    this.printUsage("");
                    System.exit(0);
                }
                case 'v': {
                    dOMParser.setValidationMode(true);
                    break;
                }
                case 'w': {
                    dOMParser.showWarnings(true);
                    break;
                }
                case 'd': {
                    dOMParser.setDebugMode(true);
                    break;
                }
                case 'e': {
                    if (string.length() > 2) {
                        string2 = string.substring(2);
                        if (this.isFlag(string2)) {
                            this.printUsage("Missing <error log> after -e");
                        }
                    } else if (++n2 >= n || this.isFlag(string2 = stringArray[n2])) {
                        this.printUsage("Missing <error log> after -e");
                    }
                    try {
                        this.errors = new FileOutputStream(string2);
                    }
                    catch (IOException iOException) {
                        this.printUsage("The specified error log " + string2 + " could not be opened for writing: " + iOException.getMessage());
                    }
                    break;
                }
            }
            ++n2;
        }
        if (string != null) {
            try {
                dOMParser.setErrorStream(this.errors);
            }
            catch (IOException iOException) {
                this.exitWithError("Error while setting error log(" + iOException.getMessage() + ")");
            }
            try {
                uRL = this.createURL(string);
            }
            catch (Exception exception) {
                this.exitWithError("Error opening input source" + string + "(" + exception.getMessage() + ")");
            }
            try {
                dOMParser.parse(uRL);
            }
            catch (XMLParseException xMLParseException) {
                System.err.println("Error occurred while parsing");
                System.exit(1);
            }
            catch (Exception exception) {
                this.exitWithError("Error while parsing input source" + string + "(" + exception.getMessage() + ")");
            }
            System.err.println("The input file parsed without errors");
        }
    }
}

