/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.util.Hashtable;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.XMLAttrList;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLEntity;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLNodeList;
import org.w3c.dom.NodeList;

public class XSLSourceContext {
    XMLElement srcRoot;
    Hashtable idHashTable;
    Hashtable entityHashTable;
    XSLNodeList docOrderList;
    int docOrderCount = 0;
    Hashtable keyTable;

    XSLSourceContext(XMLElement xMLElement, XMLDocument xMLDocument) throws XSLException {
        this.srcRoot = xMLElement;
        this.docOrderList = new XSLNodeList();
        this.addToDocOrderList(this.docOrderList, xMLElement);
        if (xMLDocument != null) {
            this.idHashTable = xMLDocument.getIDHashtable();
            DTD dTD = (DTD)xMLDocument.getDoctype();
            if (dTD != null) {
                this.entityHashTable = dTD.entities;
            }
        }
    }

    private void addToDocOrderList(XSLNodeList xSLNodeList, XMLElement xMLElement) throws XSLException {
        xSLNodeList.addNode(xMLElement);
        xMLElement.docOrderId = this.docOrderCount++;
        XMLAttrList xMLAttrList = (XMLAttrList)xMLElement.getAttributes();
        int n = xMLAttrList.getLength();
        int n2 = 0;
        while (n2 < n) {
            xSLNodeList.addNode((XMLNode)xMLAttrList.item(n2));
            ++this.docOrderCount;
            ((XMLNode)xMLAttrList.item((int)n2)).docOrderId = ((XMLNode)xMLAttrList.item((int)n2)).docOrderId;
            ++n2;
        }
        if (xMLElement.hasChildNodes()) {
            NodeList nodeList = xMLElement.getChildNodes();
            int n3 = nodeList.getLength();
            int n4 = 0;
            while (n4 < n3) {
                XMLNode xMLNode = (XMLNode)nodeList.item(n4);
                if (xMLNode.getNodeType() == 1) {
                    this.addToDocOrderList(xSLNodeList, (XMLElement)xMLNode);
                } else {
                    xSLNodeList.addNode(xMLNode);
                    ++this.docOrderCount;
                    xMLNode.docOrderId = xMLNode.docOrderId;
                }
                ++n4;
            }
        }
    }

    public XSLNodeList getDocumentOrderList() throws XSLException {
        return this.docOrderList;
    }

    public XMLElement getIDElement(String string) throws XSLException {
        if (this.idHashTable == null) {
            return null;
        }
        return (XMLElement)this.idHashTable.get(string);
    }

    public Hashtable getKeyTable() throws XSLException {
        return this.keyTable;
    }

    public String getUnparsedEntityUri(String string) throws XSLException {
        if (this.entityHashTable == null) {
            return "";
        }
        XMLEntity xMLEntity = (XMLEntity)this.entityHashTable.get(string);
        if (xMLEntity == null) {
            return "";
        }
        if (xMLEntity.ndata == null) {
            return "";
        }
        return xMLEntity.url;
    }

    public void setKeyTable(Hashtable hashtable) throws XSLException {
        this.keyTable = hashtable;
    }
}

