/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Stack;
import oracle.xml.parser.v2.DefaultXMLDocumentHandler;
import oracle.xml.parser.v2.NSName;
import oracle.xml.parser.v2.SAXAttrList;
import oracle.xml.parser.v2.XMLDeclPI;
import oracle.xml.parser.v2.XMLOutputStream;
import oracle.xml.parser.v2.XMLUtil;
import oracle.xml.parser.v2.XSLOutput;
import org.xml.sax.SAXException;

class XSLSAXPrintDriver
extends DefaultXMLDocumentHandler {
    boolean printWriter;
    XMLOutputStream out;
    XSLOutput xslOut;
    Stack elemNames = new Stack();
    String buffer = null;
    boolean prolog = false;
    boolean elemEmpty = true;
    boolean textPrinted = false;
    boolean disableOutEsc = false;
    boolean firstElement = true;
    boolean scriptORstyle = false;
    int outMethod = UNKNOWN;
    static int HTML = 0;
    static int XML = 1;
    static int TEXT = 2;
    static int UNKNOWN = 3;
    private static Hashtable emptyTags = new Hashtable(20);

    static {
        emptyTags.put("area", "area");
        emptyTags.put("base", "base");
        emptyTags.put("basefont", "basefont");
        emptyTags.put("br", "br");
        emptyTags.put("col", "col");
        emptyTags.put("frame", "frame");
        emptyTags.put("hr", "hr");
        emptyTags.put("img", "img");
        emptyTags.put("input", "input");
        emptyTags.put("isindex", "isindex");
        emptyTags.put("link", "link");
        emptyTags.put("meta", "meta");
        emptyTags.put("param", "param");
    }

    public XSLSAXPrintDriver(OutputStream outputStream, XSLOutput xSLOutput) {
        this.out = new XMLOutputStream(outputStream);
        this.printWriter = false;
        this.xslOut = xSLOutput;
    }

    public XSLSAXPrintDriver(PrintWriter printWriter, XSLOutput xSLOutput) {
        this.out = new XMLOutputStream(printWriter);
        this.printWriter = true;
        this.xslOut = xSLOutput;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.elemEmpty = false;
        this.textPrinted = true;
        try {
            int n3;
            int n4;
            if (this.outMethod == UNKNOWN) {
                n4 = 1;
                n3 = 0;
                while (n3 < n2) {
                    if (!XMLUtil.isWhiteSpaceChar(cArray[n3])) {
                        n4 = 0;
                        break;
                    }
                    ++n3;
                }
                if (n4 == 0) {
                    this.outMethod = XML;
                    this.printXMLDecl();
                }
            }
            n4 = n + n2;
            if (this.outMethod == TEXT || this.disableOutEsc || this.scriptORstyle) {
                n3 = n;
                while (n3 < n4) {
                    this.out.write(cArray[n3]);
                    ++n3;
                }
                return;
            }
            if (!this.elemNames.empty() && this.xslOut.checkCDATASectionElement((String)this.elemNames.peek())) {
                this.out.writeChars("<![CDATA[");
                n3 = n;
                while (n3 < n4) {
                    if (n3 > 1 && cArray[n3] == '>') {
                        if (cArray[n3 - 1] == ']' && cArray[n3 - 2] == ']') {
                            this.out.writeChars("]]><![CDATA[");
                        }
                        this.out.write(62);
                    } else {
                        this.out.write(cArray[n3]);
                    }
                    ++n3;
                }
                this.out.writeChars("]]>");
                return;
            }
            n3 = n;
            while (n3 < n4) {
                if (cArray[n3] == '&') {
                    this.out.writeChars("&#38;");
                } else if (cArray[n3] == '<') {
                    this.out.writeChars("&#60;");
                } else if (n3 > 1 && cArray[n3] == '>') {
                    if (this.outMethod == HTML || cArray[n3 - 1] == ']' && cArray[n3 - 2] == ']') {
                        this.out.writeChars("&gt;");
                    } else {
                        this.out.write(62);
                    }
                } else if (cArray[n3] == '\u00a0') {
                    if (this.outMethod == HTML) {
                        this.out.writeChars("&nbsp;");
                    } else {
                        this.out.write(cArray[n3]);
                    }
                } else {
                    this.out.write(cArray[n3]);
                }
                ++n3;
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
    }

    public void close() throws IOException {
        this.out.close();
    }

    public void comment(String string) throws SAXException {
        try {
            if (this.outMethod == TEXT) {
                return;
            }
            if (!this.textPrinted && !this.firstElement) {
                this.out.writeNewLine();
                this.out.writeIndent();
            }
            this.firstElement = false;
            this.elemEmpty = false;
            this.textPrinted = false;
            this.out.writeChars("<!--");
            this.out.writeChars(string);
            this.out.writeChars("-->");
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
    }

    public void endElement(NSName nSName) throws SAXException {
        try {
            if (this.outMethod == TEXT) {
                return;
            }
            this.out.addIndent(-1);
            this.elemNames.pop();
            if (this.outMethod == HTML) {
                this.scriptORstyle = false;
                if (emptyTags.get(nSName.getLocalName().toLowerCase()) != null && nSName.getNamespace().equals("")) {
                    this.elemEmpty = false;
                    this.textPrinted = false;
                    return;
                }
            }
            if (this.elemEmpty) {
                if (this.outMethod == HTML) {
                    this.out.writeChars("</" + nSName.getQualifiedName() + ">");
                } else {
                    this.out.pop(1);
                    this.out.writeChars("/>");
                }
            } else {
                if (!this.textPrinted) {
                    this.out.writeNewLine();
                    this.out.writeIndent();
                }
                this.out.writeChars("</" + nSName.getQualifiedName() + ">");
            }
            this.elemEmpty = false;
            this.textPrinted = false;
            return;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
    }

    public void flush() throws IOException {
        if (this.outMethod == UNKNOWN) {
            this.outMethod = XML;
            this.printXMLDecl();
        }
        this.out.flush();
    }

    void init() throws SAXException {
        try {
            this.setEncoding(this.xslOut.getEncoding());
            String string = this.xslOut.getMethod();
            if (string == XSLOutput.HTML) {
                this.outMethod = HTML;
            } else {
                if (string == XSLOutput.TEXT) {
                    this.outMethod = TEXT;
                    return;
                }
                if (string == XSLOutput.XML) {
                    this.outMethod = XML;
                }
            }
            if (this.outMethod == XML) {
                this.printXMLDecl();
            }
            if (this.outMethod == UNKNOWN) {
                this.out.holdBuffer = true;
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
    }

    void printAttributes(SAXAttrList sAXAttrList) throws SAXException, IOException {
        int n = sAXAttrList.getLength();
        int n2 = 0;
        while (n2 < n) {
            this.out.writeChars(" ");
            this.out.writeChars(sAXAttrList.getQualifiedName(n2));
            String string = sAXAttrList.getValue(n2);
            if (this.outMethod != HTML || !sAXAttrList.getQualifiedName(n2).equals(string)) {
                int n3;
                this.out.writeChars("=");
                this.out.write(34);
                int n4 = string.length();
                char[] cArray = new char[n4];
                string.getChars(0, n4, cArray, 0);
                if (this.disableOutEsc) {
                    n3 = 0;
                    while (n3 < n4) {
                        this.out.write(cArray[n3]);
                        ++n3;
                    }
                } else {
                    n3 = 0;
                    while (n3 < n4) {
                        if (cArray[n3] == '&') {
                            if (this.outMethod == HTML && n3 + 1 < n4 && cArray[n3 + 1] == '{') {
                                this.out.write(38);
                            } else {
                                this.out.writeChars("&#38;");
                            }
                        } else if (cArray[n3] == '<') {
                            this.out.writeChars("&#60;");
                        } else if (cArray[n3] == '\"') {
                            this.out.writeChars("&#34;");
                        } else if (cArray[n3] == '\'') {
                            this.out.writeChars("&#39;");
                        } else {
                            this.out.write(cArray[n3]);
                        }
                        ++n3;
                    }
                }
                this.out.write(34);
            }
            ++n2;
        }
    }

    void printProlog(NSName nSName) throws IOException {
        String string;
        this.prolog = true;
        if (this.xslOut.getMethod() == "") {
            string = nSName.getLocalName().toLowerCase().intern();
            if (string == "html" && nSName.getNamespace().equals("")) {
                this.outMethod = HTML;
                this.out.holdBuffer = false;
                this.xslOut.setMethod(XSLOutput.HTML);
            } else if (this.outMethod == UNKNOWN) {
                this.outMethod = XML;
                this.printXMLDecl();
            }
        }
        String string2 = this.xslOut.getDoctypeSystem();
        string = this.xslOut.getDoctypePublic();
        if (string2 != "" || this.outMethod == HTML && string != "") {
            this.out.writeChars("<!DOCTYPE " + nSName.getQualifiedName() + " ");
            if (string != "") {
                this.out.writeChars("PUBLIC ");
                this.out.writeQuotedString(string);
                this.out.write(32);
            } else if (string2 != "") {
                this.out.writeChars("SYSTEM ");
            }
            if (string2 != "") {
                this.out.writeQuotedString(string2);
            }
            this.out.writeChars(">");
            this.out.writeNewLine();
        }
        if (!this.xslOut.getIndent()) {
            this.out.outstyle = XMLOutputStream.COMPACT;
        }
    }

    void printXMLDecl() throws IOException {
        if (!this.xslOut.getOmitXMLDecl()) {
            String string = null;
            string = this.xslOut.getEncoding();
            XMLDeclPI xMLDeclPI = this.xslOut.getStandalone() == "" ? new XMLDeclPI(this.xslOut.getVersion(), string, null, false) : new XMLDeclPI(this.xslOut.getVersion(), string, this.xslOut.getStandalone(), false);
            if (this.out.bufLength() > 0) {
                this.out.altBuffer();
                xMLDeclPI.print(this.out, false);
                this.out.priBuffer();
            } else {
                xMLDeclPI.print(this.out, false);
            }
        }
        this.out.holdBuffer = false;
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        try {
            if (this.outMethod == TEXT) {
                return;
            }
            if (!this.textPrinted && !this.firstElement) {
                this.out.writeNewLine();
                this.out.writeIndent();
            }
            this.firstElement = false;
            this.elemEmpty = false;
            this.textPrinted = false;
            this.out.writeChars("<?");
            this.out.writeChars(String.valueOf(string) + " " + string2);
            if (this.outMethod == XML) {
                this.out.writeChars("?>");
            } else {
                this.out.writeChars(">");
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
    }

    void setDisableOutEsc(boolean bl) {
        this.disableOutEsc = bl;
    }

    public void setEncoding(String string) throws IOException {
        if (!this.printWriter) {
            this.out.setEncoding(string, true, true);
        }
    }

    public void startElement(NSName nSName, SAXAttrList sAXAttrList) throws SAXException {
        try {
            String string;
            if (this.outMethod == TEXT) {
                return;
            }
            if (!this.prolog) {
                this.printProlog(nSName);
            } else if (!this.textPrinted && !this.firstElement) {
                this.out.writeNewLine();
                this.out.writeIndent();
            }
            if (this.outMethod == HTML) {
                string = nSName.getLocalName().toLowerCase().intern();
                if (string == "script" || string == "style") {
                    this.scriptORstyle = true;
                }
            } else if (this.outMethod == UNKNOWN) {
                this.outMethod = XML;
                this.printXMLDecl();
            }
            this.firstElement = false;
            this.elemEmpty = true;
            this.textPrinted = false;
            this.elemNames.push(nSName.getExpandedName());
            this.out.writeChars("<");
            this.out.writeChars(nSName.getQualifiedName());
            this.printAttributes(sAXAttrList);
            this.out.writeChars(">");
            this.out.addIndent(1);
            if (this.outMethod == HTML && (string = nSName.getLocalName().toLowerCase().intern()) == "head") {
                this.out.writeNewLine();
                this.out.writeIndent();
                if (this.xslOut.isEncodingSpecified()) {
                    this.out.writeChars("<META http-equiv=\"Content-Type\" content=\"" + this.xslOut.getMediaType() + "; charset=" + this.xslOut.getEncoding() + "\">");
                } else {
                    this.out.writeChars("<META http-equiv=\"Content-Type\" content=\"" + this.xslOut.getMediaType() + "\">");
                }
                this.elemEmpty = false;
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
    }
}

