/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import oracle.xml.parser.v2.XMLConstants;
import oracle.xml.parser.v2.XMLDOMException;
import oracle.xml.parser.v2.XMLReader;
import org.w3c.dom.DOMException;

public class XMLUtil
implements XMLConstants {
    static final int[] chartype = new int[256];
    static final char[] charupper = new char[256];

    static {
        int n = 0;
        while (n < 256) {
            char c = (char)n;
            XMLUtil.chartype[n] = 0;
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n') {
                XMLUtil.chartype[n] = 1;
            }
            if (Character.isLetter(c)) {
                int n2 = n;
                chartype[n2] = chartype[n2] | 4;
            }
            if (Character.isDigit(c)) {
                int n3 = n;
                chartype[n3] = chartype[n3] | 2;
            }
            XMLUtil.charupper[n] = Character.toUpperCase(c);
            ++n;
        }
        chartype[46] = chartype[46] | 8;
        chartype[45] = chartype[45] | 8;
        chartype[95] = chartype[95] | 0x18;
        chartype[183] = chartype[183] | 8;
    }

    static boolean compareNamespace(String string, String string2) {
        if (string2.equals("*")) {
            return true;
        }
        return string.equals(string2);
    }

    public static final String getJavaEncoding(String string) {
        String string2;
        String string3 = System.getProperty("java.version", "1.1");
        if (string3.startsWith("1.1") && (string2 = (String)XMLReader.encodingMap116.get(string)) != null) {
            return string2;
        }
        return (String)XMLReader.encodingMap.get(string);
    }

    public static final boolean isFirstNameChar(char c) {
        if (c < '\u0100') {
            return (chartype[c] & 0x14) != 0;
        }
        return Character.isLetter(c) || c == '_';
    }

    public static final boolean isNameChar(char c) {
        if (c < '\u0100') {
            return (chartype[c] & 0xE) != 0;
        }
        return Character.isLetter(c) || Character.isDigit(c) || c == '-' || c == '_' || c == '.';
    }

    public static final boolean isWhiteSpaceChar(char c) {
        if (c < '\u0100') {
            return (chartype[c] & 1) != 0;
        }
        return Character.isWhitespace(c);
    }

    public static void validateName(String string) throws DOMException {
        char c = string.charAt(0);
        if (Character.isLetter(c) || c == '_' || c == ':') {
            int n = string.length();
            int n2 = 1;
            while (n2 < n) {
                c = string.charAt(n2);
                if (!Character.isLetterOrDigit(c) && c != '_' && c != ':' && c != '-' && c != '.') {
                    throw new XMLDOMException(5);
                }
                ++n2;
            }
        } else {
            throw new XMLDOMException(5);
        }
    }
}

