/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.IOException;
import java.io.Serializable;
import oracle.xml.parser.v2.CharData;
import oracle.xml.parser.v2.XMLDOMException;
import oracle.xml.parser.v2.XMLOutputStream;
import oracle.xml.parser.v2.XMLUtil;
import org.w3c.dom.DOMException;
import org.w3c.dom.Text;

public class XMLText
extends CharData
implements Text,
Serializable {
    private boolean isWhitespace = true;
    private char[] textchars;
    private int textpos;
    private int textsize;
    private static final int INCR = 128;
    int[] outputEscArray = new int[8];
    int currentOutputIndex = 0;
    int outputEscArrayLen = 8;

    XMLText() {
        super("#text", (short)3);
    }

    public XMLText(String string) {
        super("#text", (short)3);
        int n = string.length();
        char[] cArray = new char[n];
        this.textsize = n;
        this.textpos = -1;
        this.textchars = new char[this.textsize];
        string.getChars(0, n, cArray, 0);
        this.addText(cArray, 0, n);
    }

    XMLText(char[] cArray, int n, int n2) {
        super("#text", (short)3);
        this.textsize = n2;
        this.textpos = -1;
        this.textchars = new char[this.textsize];
        this.addText(cArray, n, n2);
    }

    public void addText(char[] cArray, int n, int n2) {
        int n3;
        int n4;
        if (this.isWhitespace) {
            n4 = n + n2;
            n3 = n;
            while (n3 < n4) {
                if (!XMLUtil.isWhiteSpaceChar(cArray[n3])) {
                    this.isWhitespace = false;
                    break;
                }
                ++n3;
            }
        }
        if (this.textpos != -1 && n2 > this.textsize - (this.textpos + 1)) {
            n4 = n2 + this.textpos + 1;
            n3 = this.textsize + 128;
            if (n4 < n3) {
                n4 = n3;
            }
            char[] cArray2 = this.textchars;
            this.textchars = new char[n4];
            System.arraycopy(cArray2, 0, this.textchars, 0, this.textpos + 1);
            this.textsize = n4;
        }
        System.arraycopy(cArray, n, this.textchars, this.textpos + 1, n2);
        this.textpos += n2;
    }

    void checkArray() {
        if (this.currentOutputIndex == this.outputEscArrayLen) {
            int[] nArray = this.outputEscArray;
            this.outputEscArray = new int[this.outputEscArrayLen * 2];
            System.arraycopy(nArray, 0, this.outputEscArray, 0, this.outputEscArrayLen);
            this.outputEscArrayLen *= 2;
        }
    }

    public String getNodeValue() throws DOMException {
        return this.getText();
    }

    public String getText() {
        if (this.text == null) {
            this.text = new String(this.textchars, 0, this.textpos + 1);
        }
        return this.text;
    }

    boolean isDisableOutputEscaping() {
        return this.currentOutputIndex > 0;
    }

    public boolean isWhiteSpaceNode() {
        return this.isWhitespace;
    }

    void print(XMLOutputStream xMLOutputStream, boolean bl) throws IOException {
        int n = this.getText().length();
        char[] cArray = new char[n];
        this.text.getChars(0, n, cArray, 0);
        int n2 = 0;
        while (n2 < n) {
            if (cArray[n2] == '&') {
                xMLOutputStream.writeChars("&#38;");
            } else if (cArray[n2] == '<') {
                xMLOutputStream.writeChars("&#60;");
            } else if (n2 > 1 && cArray[n2] == '>') {
                if (bl || cArray[n2 - 1] == ']' && cArray[n2 - 2] == ']') {
                    xMLOutputStream.writeChars("&gt;");
                } else {
                    xMLOutputStream.write(62);
                }
            } else {
                xMLOutputStream.write(cArray[n2]);
            }
            ++n2;
        }
        xMLOutputStream.flush();
    }

    void setDisableOutputEscaping(int n) {
        this.checkArray();
        this.outputEscArray[this.currentOutputIndex++] = this.text.length() - n;
        this.outputEscArray[this.currentOutputIndex++] = this.text.length();
    }

    public Text splitText(int n) throws DOMException {
        this.checkReadOnly();
        XMLText xMLText = new XMLText();
        String string = this.getText();
        try {
            xMLText.setData(string.substring(0, n));
            this.setData(string.substring(n, string.length()));
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new XMLDOMException(1, this.getXMLError());
        }
        this.parent.insertBefore(xMLText, this, true);
        return xMLText;
    }
}

