/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.IOException;
import java.io.Serializable;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLOutputStream;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class XMLNodeList
implements NodeList,
Serializable,
Cloneable {
    XMLNode[] nodeArray;
    int nodeCount;
    int nodeSize;

    public XMLNodeList() {
        this.nodeSize = 4;
        this.nodeCount = 0;
        this.nodeArray = new XMLNode[this.nodeSize];
    }

    public XMLNodeList(int n) {
        this.nodeSize = n;
        this.nodeCount = 0;
        this.nodeArray = new XMLNode[this.nodeSize];
    }

    public void addNode(Node node) {
        this.ensureCapacity();
        this.nodeArray[this.nodeCount] = (XMLNode)node;
        ++this.nodeCount;
    }

    public Object clone() {
        XMLNodeList xMLNodeList = new XMLNodeList(this.nodeSize);
        xMLNodeList.nodeSize = this.nodeSize;
        xMLNodeList.nodeCount = this.nodeCount;
        System.arraycopy(this.nodeArray, 0, xMLNodeList.nodeArray, 0, this.nodeCount);
        return xMLNodeList;
    }

    void ensureCapacity() {
        if (this.nodeCount >= this.nodeSize) {
            XMLNode[] xMLNodeArray = this.nodeArray;
            this.nodeArray = new XMLNode[this.nodeSize * 2];
            System.arraycopy(xMLNodeArray, 0, this.nodeArray, 0, this.nodeSize);
            this.nodeSize *= 2;
        }
    }

    public int getLength() {
        return this.nodeCount;
    }

    public int indexOf(Node node) {
        int n = 0;
        while (n < this.nodeCount) {
            if (this.nodeArray[n] == node) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void insertNode(Node node, int n) {
        this.ensureCapacity();
        System.arraycopy(this.nodeArray, n, this.nodeArray, n + 1, this.nodeCount - n);
        this.nodeArray[n] = (XMLNode)node;
        ++this.nodeCount;
    }

    public Node item(int n) {
        if (n >= 0 && n < this.nodeCount) {
            return this.nodeArray[n];
        }
        return null;
    }

    public void print(XMLOutputStream xMLOutputStream, boolean bl) throws IOException {
        int n = 0;
        while (n < this.nodeCount) {
            this.nodeArray[n].print(xMLOutputStream, bl);
            ++n;
        }
    }

    public Node removeNode(Node node) {
        int n = this.indexOf(node);
        if (n == -1) {
            return null;
        }
        int n2 = this.nodeCount - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.nodeArray, n + 1, this.nodeArray, n, n2);
        }
        --this.nodeCount;
        this.nodeArray[this.nodeCount] = null;
        return node;
    }

    public void reset() {
        this.nodeCount = 0;
    }

    public void setNode(Node node, int n) {
        this.nodeArray[n] = (XMLNode)node;
    }

    public XMLNode trustedItem(int n) {
        return this.nodeArray[n];
    }
}

