/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.NodeFactory;
import oracle.xml.parser.v2.PrintDriver;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLCDATA;
import oracle.xml.parser.v2.XMLComment;
import oracle.xml.parser.v2.XMLDOMException;
import oracle.xml.parser.v2.XMLDeclPI;
import oracle.xml.parser.v2.XMLDocumentFragment;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLEntityReference;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLOutputStream;
import oracle.xml.parser.v2.XMLPI;
import oracle.xml.parser.v2.XMLPrintDriver;
import oracle.xml.parser.v2.XMLText;
import oracle.xml.parser.v2.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class XMLDocument
extends XMLElement
implements Document,
Serializable {
    XMLElement root;
    public transient XMLError err;
    XMLDeclPI xmlDecl;
    DTD dtd = new DTD();
    boolean isStandalone = false;
    transient Hashtable ids;
    static transient DOMImplementation domImpl = null;

    public XMLDocument() {
        super("#document", (short)9);
        this.factory = new NodeFactory();
    }

    public void addID(String string, XMLElement xMLElement) {
        if (this.ids == null) {
            this.ids = new Hashtable(20);
        }
        this.ids.put(string, xMLElement);
    }

    public Node appendChild(Node node, boolean bl) throws DOMException {
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        DTD dTD = this.dtd;
        Node node2 = null;
        short s = node.getNodeType();
        if (s == 1) {
            if (!bl && this.root != null) {
                throw new XMLDOMException(3, this.getXMLError());
            }
            this.root = (XMLElement)node;
            bl2 = true;
        } else if (s == 7 && node.getNodeName().equals("xml")) {
            if (!bl && this.xmlDecl != null) {
                throw new XMLDOMException(3, this.getXMLError());
            }
            this.xmlDecl = (XMLDeclPI)node;
            bl3 = true;
        } else if (s == 10) {
            this.dtd = (DTD)node;
            bl4 = true;
        }
        try {
            node2 = super.appendChild(node, bl);
        }
        catch (DOMException dOMException) {
            if (bl2) {
                this.root = null;
            } else if (bl3) {
                this.xmlDecl = null;
            } else if (bl4) {
                this.dtd = dTD;
            }
            throw dOMException;
        }
        return node2;
    }

    void checkChildType(int n) throws DOMException {
        switch (n) {
            case 1: 
            case 7: 
            case 8: 
            case 10: {
                return;
            }
        }
        throw new XMLDOMException(3, this.getXMLError());
    }

    public Node cloneNode(boolean bl) {
        XMLDocument xMLDocument = new XMLDocument();
        int n = this.children.getLength();
        int n2 = 0;
        while (n2 < n) {
            XMLNode xMLNode = (XMLNode)this.children.item(n2);
            XMLNode xMLNode2 = (XMLNode)xMLNode.cloneNode(bl);
            xMLNode2.parent = xMLDocument;
            xMLNode2.doc = xMLDocument;
            xMLDocument.children.addNode(xMLNode2);
            if (xMLNode instanceof XMLElement) {
                xMLDocument.root = (XMLElement)xMLNode2;
            } else if (xMLNode instanceof XMLDeclPI && xMLNode.getNodeName().equals("xml")) {
                xMLDocument.xmlDecl = (XMLDeclPI)xMLNode2;
            } else if (xMLNode instanceof DTD) {
                xMLDocument.dtd = (DTD)xMLNode2;
            }
            ++n2;
        }
        return xMLDocument;
    }

    public Attr createAttribute(String string) throws DOMException {
        XMLUtil.validateName(string);
        XMLAttr xMLAttr = this.factory.createAttribute(string, null);
        xMLAttr.doc = this;
        return xMLAttr;
    }

    public CDATASection createCDATASection(String string) throws DOMException {
        XMLCDATA xMLCDATA = this.factory.createCDATASection(string);
        xMLCDATA.doc = this;
        return xMLCDATA;
    }

    public Comment createComment(String string) {
        XMLComment xMLComment = this.factory.createComment(string);
        xMLComment.doc = this;
        return xMLComment;
    }

    public DocumentFragment createDocumentFragment() {
        XMLDocumentFragment xMLDocumentFragment = this.factory.createDocumentFragment();
        xMLDocumentFragment.doc = this;
        return xMLDocumentFragment;
    }

    public Element createElement(String string) throws DOMException {
        XMLUtil.validateName(string);
        XMLElement xMLElement = this.factory.createElement(string);
        xMLElement.doc = this;
        return xMLElement;
    }

    public EntityReference createEntityReference(String string) throws DOMException {
        XMLUtil.validateName(string);
        XMLEntityReference xMLEntityReference = this.factory.createEntityReference(string);
        xMLEntityReference.doc = this;
        return xMLEntityReference;
    }

    public ProcessingInstruction createProcessingInstruction(String string, String string2) throws DOMException {
        if (string.toLowerCase().startsWith("xml") && !string.equals("xml-stylesheet")) {
            throw new XMLDOMException(5, this.getXMLError());
        }
        XMLUtil.validateName(string);
        XMLPI xMLPI = this.factory.createProcessingInstruction(string, string2);
        xMLPI.doc = this;
        return xMLPI;
    }

    public Text createTextNode(String string) {
        XMLText xMLText = this.factory.createTextNode(string);
        xMLText.doc = this;
        return xMLText;
    }

    public Vector expectedElements(Element element) {
        return ((XMLElement)element).expectedElements(this.dtd);
    }

    public DocumentType getDoctype() {
        return this.dtd;
    }

    public Element getDocumentElement() {
        return this.root;
    }

    public NodeList getElementsByTagName(String string) {
        return this.root != null ? this.root.getElementsByTagName(string) : null;
    }

    public final String getEncoding() {
        if (this.xmlDecl != null) {
            return this.xmlDecl.getEncoding();
        }
        return "UTF-8";
    }

    public XMLElement getIDElement(String string) {
        if (this.ids == null) {
            return null;
        }
        return (XMLElement)this.ids.get(string);
    }

    public Hashtable getIDHashtable() {
        return this.ids;
    }

    public DOMImplementation getImplementation() {
        if (domImpl == null) {
            domImpl = new DOMImplementation(){

                public boolean hasFeature(String string, String string2) {
                    if (!string.equalsIgnoreCase("XML")) {
                        return false;
                    }
                    if (string2 == null) {
                        return true;
                    }
                    return string2.equals("1.0");
                }
            };
        }
        return domImpl;
    }

    public Document getOwnerDocument() {
        return null;
    }

    public final String getStandalone() {
        if (this.xmlDecl != null) {
            return this.xmlDecl.getStandalone();
        }
        return "no";
    }

    public final String getVersion() {
        if (this.xmlDecl != null) {
            return this.xmlDecl.getVersion();
        }
        return "1.0";
    }

    Node insertBefore(Node node, Node node2, boolean bl) throws DOMException {
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        DTD dTD = null;
        Node node3 = null;
        short s = node.getNodeType();
        if (s == 1) {
            if (!bl && this.root != null) {
                throw new XMLDOMException(3, this.getXMLError());
            }
            this.root = (XMLElement)node;
            bl2 = true;
        } else if (s == 7 && node.getNodeName().equals("xml")) {
            if (!bl && this.xmlDecl != null) {
                throw new XMLDOMException(3, this.getXMLError());
            }
            this.xmlDecl = (XMLDeclPI)node;
            bl3 = true;
        } else if (s == 10) {
            dTD = this.dtd;
            this.dtd = (DTD)node;
            bl4 = true;
        }
        try {
            node3 = super.insertBefore(node, node2, bl);
        }
        catch (DOMException dOMException) {
            if (bl2) {
                this.root = null;
            } else if (bl3) {
                this.xmlDecl = null;
            } else if (bl4) {
                this.dtd = dTD;
            }
            throw dOMException;
        }
        return node3;
    }

    public void print(OutputStream outputStream) throws IOException {
        XMLPrintDriver xMLPrintDriver = new XMLPrintDriver(outputStream);
        this.print(xMLPrintDriver);
        xMLPrintDriver.flush();
    }

    public void print(OutputStream outputStream, String string) throws IOException {
        XMLPrintDriver xMLPrintDriver = new XMLPrintDriver(outputStream);
        this.print(xMLPrintDriver, string);
        xMLPrintDriver.flush();
    }

    public void print(PrintWriter printWriter) throws IOException {
        XMLPrintDriver xMLPrintDriver = new XMLPrintDriver(printWriter);
        this.print(xMLPrintDriver);
        xMLPrintDriver.flush();
    }

    public void print(PrintDriver printDriver) throws IOException {
        printDriver.setEncoding(this.getEncoding());
        printDriver.printChildNodes(this);
    }

    void print(PrintDriver printDriver, String string) throws IOException {
        String string2 = this.getEncoding();
        printDriver.setEncoding(string);
        try {
            this.setEncoding(string);
            printDriver.printChildNodes(this);
        }
        finally {
            Object var5_4 = null;
            this.setEncoding(string2);
        }
    }

    public void printExternalDTD(OutputStream outputStream) throws IOException {
        XMLOutputStream xMLOutputStream = new XMLOutputStream(outputStream);
        xMLOutputStream.err = this.err;
        xMLOutputStream.setEncoding(this.getEncoding(), true, true);
        this.dtd.print(xMLOutputStream, true);
    }

    public void printExternalDTD(OutputStream outputStream, String string) throws IOException {
        XMLOutputStream xMLOutputStream = new XMLOutputStream(outputStream);
        xMLOutputStream.err = this.err;
        xMLOutputStream.setEncoding(string, true, true);
        this.dtd.print(xMLOutputStream, true);
    }

    public void printExternalDTD(PrintWriter printWriter) throws IOException {
        XMLOutputStream xMLOutputStream = new XMLOutputStream(printWriter);
        xMLOutputStream.err = this.err;
        this.dtd.print(xMLOutputStream, true);
    }

    Node removeChild(Node node, boolean bl) throws DOMException {
        if (this.root == node) {
            this.root = null;
        } else if (this.xmlDecl == node) {
            this.xmlDecl = null;
        } else if (this.dtd == node) {
            this.dtd = null;
        }
        return super.removeChild(node, bl);
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        XMLElement xMLElement = this.root;
        XMLDeclPI xMLDeclPI = this.xmlDecl;
        DTD dTD = this.dtd;
        Node node3 = null;
        if (node2 == null) {
            throw new XMLDOMException(8, this.getXMLError());
        }
        short s = node.getNodeType();
        if (s == 1) {
            this.root = (XMLElement)node;
            bl = true;
        } else if (s == 7 && node.getNodeName().equals("xml")) {
            this.xmlDecl = (XMLDeclPI)node;
            bl2 = true;
        } else if (s == 10) {
            this.dtd = (DTD)node;
            bl3 = true;
        }
        if (xMLElement == node2 && !bl) {
            this.root = null;
        } else if (xMLDeclPI == node2 && !bl2) {
            this.xmlDecl = null;
        } else if (dTD == node2 && !bl3) {
            this.dtd = null;
        }
        try {
            node3 = super.replaceChild(node, node2);
        }
        catch (DOMException dOMException) {
            if (bl) {
                this.root = xMLElement;
            } else if (bl2) {
                this.xmlDecl = xMLDeclPI;
            } else if (bl3) {
                this.dtd = dTD;
            }
            throw dOMException;
        }
        return node3;
    }

    public void setDoctype(String string, String string2, String string3) {
        int n = this.children.getLength();
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            XMLNode xMLNode = (XMLNode)this.children.item(n2);
            if (xMLNode.type == 10) {
                ((DTD)xMLNode).sysID = string2;
                ((DTD)xMLNode).pubID = string3;
                xMLNode.tag = string;
                return;
            }
            if (xMLNode.type == 7 && xMLNode.getNodeName().equals("xml")) {
                bl = true;
            }
            ++n2;
        }
        this.dtd.sysID = string2;
        this.dtd.pubID = string3;
        this.dtd.tag = string;
        if (!bl) {
            this.insertBefore(this.dtd, this.getFirstChild(), true);
        } else {
            this.insertBefore(this.dtd, this.getFirstChild().getNextSibling(), true);
        }
    }

    public final void setEncoding(String string) {
        if (this.xmlDecl == null) {
            this.xmlDecl = new XMLDeclPI("1.0", string, null, false);
            this.insertBefore(this.xmlDecl, this.getFirstChild(), true);
        }
        this.xmlDecl.setEncoding(string);
    }

    public final void setLocale(Locale locale) {
        if (this.err == null) {
            this.err = new XMLError();
        }
        this.err.setLocale(locale);
    }

    public final void setStandalone(String string) {
        if (this.xmlDecl == null) {
            this.xmlDecl = new XMLDeclPI("1.0", null, string, false);
            this.insertBefore(this.xmlDecl, this.getFirstChild(), true);
        }
        this.isStandalone = this.xmlDecl.setStandalone(string);
    }

    public final void setVersion(String string) {
        if (this.xmlDecl == null) {
            this.xmlDecl = new XMLDeclPI(string, null, null, false);
            this.insertBefore(this.xmlDecl, this.getFirstChild(), true);
        }
        this.xmlDecl.setVersion(string);
    }

    public boolean validateElementContent(Element element) {
        return ((XMLElement)element).validateContent(this.dtd);
    }
}

