/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.IOException;
import java.io.Serializable;
import oracle.xml.parser.v2.XMLOutputStream;
import oracle.xml.parser.v2.XMLPI;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public class XMLDeclPI
extends XMLPI
implements Serializable {
    boolean textDecl;
    String encoding;
    String standalone;
    String version;
    static String defaultEncoding = "UTF-8";
    static String defaultVersion = "1.0";
    static String defaultStandalone = "no";

    public XMLDeclPI(String string, String string2, String string3, boolean bl) {
        super("xml");
        this.textDecl = bl;
        this.version = string;
        this.encoding = string2;
        this.standalone = string3;
    }

    public Node cloneNode(boolean bl) {
        return new XMLDeclPI(this.version, this.encoding, this.standalone, this.textDecl);
    }

    public String getData() throws DOMException {
        if (this.text != null) {
            return this.text;
        }
        if (!this.textDecl) {
            this.text = "version = '" + this.version + "'";
            if (this.encoding != null) {
                this.text = String.valueOf(this.text) + " " + "encoding" + " = '" + this.encoding + "'";
            }
            if (this.standalone != null) {
                this.text = String.valueOf(this.text) + " " + "standalone" + " = '" + this.standalone + "'";
            }
        } else {
            if (this.version != null) {
                this.text = "version = '" + this.version + "' ";
            }
            this.text = String.valueOf(this.text) + "encoding" + " = '" + this.encoding + "'";
        }
        return this.text;
    }

    public final String getEncoding() {
        if (this.encoding != null) {
            return this.encoding;
        }
        return defaultEncoding;
    }

    public final String getStandalone() {
        if (this.standalone != null) {
            return this.standalone;
        }
        return defaultStandalone;
    }

    public final String getVersion() {
        if (this.version != null) {
            return this.version;
        }
        return defaultVersion;
    }

    public void print(XMLOutputStream xMLOutputStream, boolean bl) throws IOException {
        if (bl == this.external) {
            xMLOutputStream.writeIndent();
            xMLOutputStream.writeChars("<?");
            xMLOutputStream.writeChars(String.valueOf(this.tag) + " " + this.getData());
            xMLOutputStream.writeChars("?>");
            xMLOutputStream.writeNewLine();
            xMLOutputStream.flush();
        }
    }

    public final void setEncoding(String string) {
        this.text = null;
        this.encoding = string;
    }

    public final boolean setStandalone(String string) {
        this.text = null;
        this.standalone = string;
        return string != null && string.equalsIgnoreCase("yes");
    }

    public final void setVersion(String string) {
        this.text = null;
        this.version = string;
    }
}

