/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import oracle.xml.parser.v2.XMLEntity;
import oracle.xml.parser.v2.XMLReader;
import org.xml.sax.SAXException;

public class XMLByteReader {
    XMLReader parent = null;
    int BUFSIZE;
    int bufNum;
    protected char[] currentBuffer;
    protected int currentPos;
    int endPos;
    int eofPos;
    byte[] buffer;
    int byteIndex;
    int endIndex;
    int eofIndex;
    int[] line;
    int lineBufSize = 1024;
    int lastLine;
    int cumLine;
    int curLine;
    String sysId;
    String pubId;
    InputStream in;
    boolean closeInput = false;
    static final int LITTLE_ENDIAN = 1;
    static final int BIG_ENDIAN = 2;
    static final int OCTET_2143 = 3;
    static final int OCTET_3412 = 4;
    int first = 0;
    int second = 1;
    int third = 2;
    int fourth = 3;
    XMLEntity en = null;
    protected static final byte[] newLine;

    static {
        byte[] byArray = new byte[256];
        byArray[10] = 1;
        byArray[13] = 1;
        byArray[255] = 3;
        newLine = byArray;
    }

    public XMLByteReader() {
        this(16388);
    }

    public XMLByteReader(int n) {
        this.BUFSIZE = n;
        this.currentBuffer = new char[this.BUFSIZE];
        this.buffer = new byte[this.BUFSIZE];
        this.byteIndex = this.BUFSIZE;
        this.currentPos = this.BUFSIZE;
        this.bufNum = 0;
        this.endIndex = this.BUFSIZE;
        this.endPos = this.BUFSIZE;
        this.eofIndex = this.BUFSIZE << 2;
        this.eofPos = this.BUFSIZE << 2;
        this.line = new int[this.lineBufSize];
        this.line[0] = 3;
        this.lastLine = 0;
        this.cumLine = 0;
        this.curLine = 1;
    }

    public XMLByteReader(InputStream inputStream, String string, String string2) throws IOException {
        this();
        this.in = inputStream;
        this.sysId = string;
        this.pubId = string2;
    }

    public void close() throws SAXException {
        try {
            if (this.in != null && this.closeInput) {
                this.in.close();
            }
        }
        catch (IOException iOException) {}
    }

    int copyPushBack(int n) {
        if (this.bufNum <= 0) {
            n = this.BUFSIZE - 4;
        }
        if (n <= 0) {
            n = this.BUFSIZE;
        }
        int n2 = this.BUFSIZE - n;
        this.resetLineNumber(n);
        if (n2 <= 0) {
            n2 = 0;
        } else {
            System.arraycopy(this.currentBuffer, n, this.currentBuffer, 0, n2);
        }
        ++this.bufNum;
        return n2;
    }

    void dump(String string) {
        PrintWriter printWriter = new PrintWriter(System.out);
        printWriter.println("");
        printWriter.println("--- " + string + " : " + this + ".DUMP:");
        printWriter.println("--- [0.." + this.parent.currentPos + "]");
        printWriter.write(this.currentBuffer, 0, this.parent.currentPos);
        printWriter.println("");
        printWriter.println("--- [" + this.parent.currentPos + ".." + this.endPos + "] eofPos = " + this.eofPos);
        printWriter.write(this.currentBuffer, this.parent.currentPos, this.endPos - this.parent.currentPos);
        printWriter.println("");
        printWriter.flush();
    }

    int fillBuffer(int n) throws IOException {
        this.endPos = this.currentPos = this.copyPushBack(n);
        while (true) {
            try {
                block8: while (true) {
                    byte by = this.buffer[this.byteIndex];
                    switch (newLine[by & 0xFF]) {
                        default: {
                            continue block8;
                        }
                        case 0: {
                            this.currentBuffer[this.endPos] = (char)by;
                            ++this.endPos;
                            ++this.byteIndex;
                            continue block8;
                        }
                        case 1: {
                            this.currentBuffer[this.endPos] = 10;
                            this.setLineNumber(this.endPos);
                            ++this.endPos;
                            ++this.byteIndex;
                            if (by != 13 || this.buffer[this.byteIndex] != 10) continue block8;
                            ++this.byteIndex;
                            continue block8;
                        }
                        case 3: 
                    }
                    if (this.byteIndex >= this.eofIndex) {
                        this.setEOF(this.endPos);
                        return this.currentPos;
                    }
                    this.currentBuffer[this.endPos] = (char)by;
                    ++this.endPos;
                    ++this.byteIndex;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (this.endPos < this.BUFSIZE) {
                    this.fillByteBuffer();
                    continue;
                }
                return this.currentPos;
            }
            break;
        }
    }

    void fillByteBuffer() throws IOException {
        int n = 0;
        this.byteIndex = 0;
        this.endIndex = 0;
        for (int i = this.BUFSIZE; i != 0; i -= n) {
            n = this.in.read(this.buffer, this.endIndex, i);
            if (n != -1) {
                this.endIndex += n;
                continue;
            }
            if (this.endIndex < this.BUFSIZE) {
                this.buffer[this.endIndex] = -1;
            }
            this.eofIndex = this.endIndex;
            break;
        }
    }

    public char[] getBuffer() {
        return this.currentBuffer;
    }

    public int getColumnNumber() {
        this.getLineNumber();
        return this.currentPos - this.line[this.lastLine - 1];
    }

    public int getLineNumber() {
        this.currentPos = this.parent != null && this.parent.input == this ? this.parent.currentPos : this.currentPos;
        int n = this.lastLine;
        while (n < this.curLine) {
            if (this.currentPos <= this.line[n]) {
                this.lastLine = n;
                return this.cumLine + n;
            }
            ++n;
        }
        this.lastLine = this.curLine;
        return this.cumLine + this.curLine;
    }

    public int getPos() {
        return this.currentPos;
    }

    void push() throws SAXException {
        if (this.parent != null) {
            --this.parent.currentPos;
        } else {
            --this.currentPos;
        }
    }

    void push(int n) throws SAXException {
        if (this.parent != null) {
            this.parent.currentPos -= n;
        } else {
            this.currentPos -= n;
        }
    }

    void pushBytes(int[] nArray, int n, int n2) {
        while (n2 > n) {
            this.buffer[--this.byteIndex] = (byte)nArray[--n2];
        }
    }

    void pushChar(int n) throws SAXException {
        if (this.parent != null) {
            this.currentBuffer[--this.parent.currentPos] = (char)n;
        } else {
            this.currentBuffer[--this.currentPos] = (char)n;
        }
    }

    void pushChar(char[] cArray, int n, int n2) throws SAXException {
        while (n2-- > 0) {
            this.pushChar(cArray[n + n2]);
        }
    }

    void resetLineNumber(int n) {
        if (this.bufNum <= 0) {
            return;
        }
        int n2 = this.curLine;
        int n3 = this.curLine - 1;
        while (n3 >= 0) {
            if (n >= this.line[n3]) {
                n2 = n3;
                break;
            }
            --n3;
        }
        int n4 = 0;
        int n5 = n2;
        while (n5 < this.curLine) {
            this.line[n4++] = this.line[n5] - n;
            ++n5;
        }
        this.curLine = n4;
        this.cumLine += n2;
    }

    void setByteOrder(int n) {
    }

    void setEOF(int n) {
        this.eofPos = n;
        if (n < this.BUFSIZE) {
            this.currentBuffer[n] = 65535;
        }
    }

    void setLineNumber(int n) {
        try {
            this.line[this.curLine++] = n;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            int[] nArray = this.line;
            this.line = new int[this.lineBufSize * 2];
            System.arraycopy(nArray, 0, this.line, 0, this.lineBufSize);
            this.lineBufSize *= 2;
            this.line[this.curLine++] = n;
        }
    }

    public void setParent(XMLReader xMLReader) {
        this.parent = xMLReader;
    }

    public void setPos(int n) {
        this.currentPos = n;
    }
}

