/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import oracle.xml.parser.v2.AttrDecl;
import oracle.xml.parser.v2.ContentModel;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.DTDDecl;
import oracle.xml.parser.v2.ParserState;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLOutputStream;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ElementDecl
extends XMLNode
implements Serializable {
    public ContentModel content;
    public boolean decl = true;
    public boolean idAttr = false;
    Vector attrdecls;
    public static final byte EMPTY = 1;
    public static final byte ANY = 2;
    public static final byte MIXED = 3;
    public static final byte ELEMENTS = 4;
    public static final int ELEMENT = 1001;
    public static final int OR = 1002;
    public static final int COMMA = 1003;
    public static final int QMARK = 1004;
    public static final int ASTERISK = 1005;
    public static final int PLUS = 1006;

    public ElementDecl(String string) {
        super(string, (short)13);
    }

    public ElementDecl(String string, byte by) {
        super(string, (short)13);
        this.content = new ContentModel();
        this.content.type = by;
    }

    public final void addAttrDecl(AttrDecl attrDecl) {
        if (this.attrdecls == null) {
            this.attrdecls = new Vector();
        }
        this.attrdecls.addElement(attrDecl);
        this.appendChild(attrDecl, true);
    }

    public boolean checkAcceptState(ParserState parserState) throws XMLParseException {
        if (this.content != null) {
            return this.content.checkAcceptState(parserState);
        }
        return false;
    }

    public boolean checkContent(ParserState parserState, String string) throws XMLParseException {
        if (this.content != null) {
            return this.content.checkContent(parserState, string);
        }
        return false;
    }

    public final Vector expectedElements(int n) {
        if (this.content.type == 1) {
            return new Vector(0);
        }
        return this.content.expectedElements(n);
    }

    public Vector expectedElements(Element element) {
        if (this.content.type == 1 || this.content.type == 2) {
            return this.getContentElements();
        }
        if (this.content != null) {
            return this.content.expectedElements((XMLElement)element, (DTD)this.parent);
        }
        return null;
    }

    public final AttrDecl findAttrDecl(String string) {
        if (this.attrdecls != null) {
            Enumeration enumeration = this.attrdecls.elements();
            while (enumeration.hasMoreElements()) {
                AttrDecl attrDecl = (AttrDecl)enumeration.nextElement();
                if (!attrDecl.tag.equals(string)) continue;
                return attrDecl;
            }
        }
        return null;
    }

    public final int getAttrDeclIndex(String string) {
        if (this.attrdecls != null) {
            int n = 0;
            while (n < this.attrdecls.size()) {
                AttrDecl attrDecl = (AttrDecl)this.attrdecls.elementAt(n);
                if (attrDecl.tag.equals(string)) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    public NamedNodeMap getAttrDecls() {
        if (this.attrdecls != null) {
            return new DTDDecl(this.attrdecls);
        }
        return null;
    }

    public final Vector getContentElements() {
        if (this.content == null || !this.decl) {
            return null;
        }
        Vector vector = new Vector();
        if (this.content.type == 1) {
            return null;
        }
        if (this.content.type == 2) {
            if (this.parent == null) {
                return null;
            }
            Enumeration enumeration = ((DTD)this.parent).elementdecls.elements();
            while (enumeration.hasMoreElements()) {
                vector.addElement(((ElementDecl)enumeration.nextElement()).tag);
            }
        } else {
            vector = (Vector)this.content.getContentElements().clone();
        }
        return vector;
    }

    public int getContentType() {
        if (this.content == null || !this.decl) {
            return 1;
        }
        return this.content.type;
    }

    public final Node getParseTree() {
        return this.content.getRoot();
    }

    void print(XMLOutputStream xMLOutputStream, boolean bl) throws IOException {
        if (bl == this.external && this.decl) {
            xMLOutputStream.writeChars("<!ELEMENT ");
            xMLOutputStream.writeChars(String.valueOf(this.tag) + " ");
            if (this.content != null) {
                this.content.print(xMLOutputStream);
            } else {
                xMLOutputStream.writeChars("EMPTY");
            }
            xMLOutputStream.writeChars(">");
            xMLOutputStream.writeNewLine();
        }
        if (this.children != null) {
            this.children.print(xMLOutputStream, bl);
        }
        xMLOutputStream.flush();
    }

    public final void removeAttrDeclAt(int n) {
        if (this.attrdecls != null) {
            this.attrdecls.removeElementAt(n);
        }
    }

    public boolean validateContent(Element element) {
        if (this.content.type == 1) {
            return element.hasChildNodes() ^ true;
        }
        if (this.content.type == 2) {
            return true;
        }
        if (this.content != null) {
            return this.content.validateContent((XMLElement)element, (DTD)this.parent);
        }
        return false;
    }
}

