/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oracle.jsp.app.JspAppLoader;
import oracle.jsp.runtime.JspHttpRequest;
import oracle.jsp.util.JspVersion;

public class JspUtil {
    public static final String DEFAULT_PAGE = "index.jsp";
    public static final String INCLUDED_REQUEST_URI = "javax.servlet.include.request_uri";
    public static final String INCLUDED_CONTEXT_PATH = "javax.servlet.include.context_path";
    public static final String INCLUDED_SERVLET_PATH = "javax.servlet.include.servlet_path";
    public static final String INCLUDED_PATH_INFO = "javax.servlet.include.path_info";
    public static final String INCLUDED_QUERY_STRING = "javax.servlet.include.query_string";
    public static final String REQCLASS_OJSP = "oracle.jsp.provider.JspUniversalHttpRequest";
    public static final String REQCLASS_JSERVE = "org.apache.jserv.JServConnection";
    public static final String REQCLASS_JWS = "com.sun.server.http.HttpServiceRequest";
    public static final String REQCLASS_JSWDK = "com.sun.web.core.HttpServletRequestFacade";
    public static final String REQCLASS_TOMCAT = "org.apache.tomcat.core.HttpServletRequestFacade";
    public static final String REQCLASS_OSEJDK = "oracle.aurora.mts.http.connector.HttpRequest";
    private static final String MESSAGE_FILE = "oracle.jsp.util.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.util.LocalStrings");
    public static boolean encodeToJavaFlag = true;

    public static String getRequestURI(HttpServletRequest httpServletRequest) {
        String string = (String)httpServletRequest.getAttribute(INCLUDED_REQUEST_URI);
        if (string == null) {
            string = httpServletRequest.getRequestURI();
            int n = string.indexOf("?");
            if (n != -1) {
                string = string.substring(0, n);
            }
        } else if (JspVersion.getServletVersion(null) > 1) {
            if (JspVersion.getServletVersion(null) >= 3) {
                HttpServletRequest httpServletRequest2 = null;
                httpServletRequest2 = httpServletRequest instanceof JspHttpRequest ? ((JspHttpRequest)httpServletRequest).getNativeRequest() : httpServletRequest;
                if (!httpServletRequest2.getClass().getName().equals(REQCLASS_OSEJDK)) {
                    string = String.valueOf(httpServletRequest.getContextPath()) + string;
                }
            } else {
                string = JspUtil.normalizeRequestURI(httpServletRequest, string);
            }
        }
        if (!JspUtil.hasTarget(string)) {
            return JspUtil.addTarget(string);
        }
        return string;
    }

    public static boolean servletPathContainsServletName(HttpServletRequest httpServletRequest) {
        while (httpServletRequest instanceof JspHttpRequest) {
            httpServletRequest = ((JspHttpRequest)httpServletRequest).getNativeRequest();
        }
        String string = httpServletRequest.getClass().getName();
        if (string.equals(REQCLASS_JSERVE)) {
            return true;
        }
        String string2 = httpServletRequest.getServletPath();
        return string2.regionMatches(false, 0, JspAppLoader.getOJSP_SERVLET_NAME(), 0, JspAppLoader.getOJSP_SERVLET_NAME().length());
    }

    private static String normalizeRequestURI(HttpServletRequest httpServletRequest, String string) {
        int n;
        String string2 = httpServletRequest.getRequestURI();
        String string3 = httpServletRequest.getServletPath();
        String string4 = JspUtil.getTarget(string);
        if (string3 == null || string3.length() <= 1 || JspUtil.servletPathContainsServletName(httpServletRequest)) {
            string3 = httpServletRequest.getPathInfo();
        }
        if ((n = (string2 = JspUtil.stripTarget(string2, '/')).indexOf(string3 = JspUtil.stripTarget(string3, '/'))) == -1) {
            return string;
        }
        if (string3.equals("/")) {
            return String.valueOf(string2) + "/" + string4;
        }
        if (n == 0) {
            return string;
        }
        if (!string.startsWith(string2 = string2.substring(0, n))) {
            return String.valueOf(string2) + string3 + "/" + string4;
        }
        return string;
    }

    public static String getServletPath(HttpServletRequest httpServletRequest) {
        String string = (String)httpServletRequest.getAttribute(INCLUDED_SERVLET_PATH);
        if (string != null) {
            return string;
        }
        return httpServletRequest.getServletPath();
    }

    public static String getPathInfo(HttpServletRequest httpServletRequest) {
        String string = (String)httpServletRequest.getAttribute(INCLUDED_PATH_INFO);
        if (string != null) {
            return string;
        }
        return httpServletRequest.getPathInfo();
    }

    public static String getQueryString(HttpServletRequest httpServletRequest) {
        String string = (String)httpServletRequest.getAttribute(INCLUDED_QUERY_STRING);
        if (string != null) {
            return string;
        }
        return httpServletRequest.getQueryString();
    }

    public static String getFullClassNameFromURL(String string) {
        string = JspUtil.stripProtocol(string);
        String string2 = JspUtil.getClassNameFromURL(string);
        String string3 = JspUtil.stripTarget(string, '/').toLowerCase();
        string3 = string3.length() <= 1 ? "" : string3.substring(1).replace('/', '.');
        if ((string3 = JspUtil.encodeToJavaIdentifier(string3, '.')).length() > 0) {
            return String.valueOf(string3) + "." + string2;
        }
        return string2;
    }

    public static String getClassNameFromURL(String string) {
        String string2 = JspUtil.getTarget(string);
        int n = string2.lastIndexOf(46);
        if (n == -1) {
            return JspUtil.encodeToJavaIdentifier(string2, '\uffff');
        }
        String string3 = string2.substring(0, n);
        return JspUtil.encodeToJavaIdentifier(string3, '\uffff');
    }

    public static String getPackageNameFromRelPath(String string, char c) {
        if (string.length() == 0) {
            string = String.valueOf(c);
        } else if (string.charAt(0) != c) {
            string = String.valueOf(c) + string;
        }
        String string2 = JspUtil.stripTarget(string, c).toLowerCase();
        string2 = string2.length() <= 1 ? "" : string2.substring(1).replace(c, '.');
        string2 = JspUtil.encodeToJavaIdentifier(string2, '.');
        return string2;
    }

    public static String getClassNameFromRelPath(String string, char c) {
        String string2;
        int n = string.lastIndexOf(c);
        if (n < 0) {
            string2 = string;
        } else {
            if (n == string.length() - 1) {
                return null;
            }
            string2 = string.substring(n + 1);
        }
        n = string2.lastIndexOf(46);
        if (n >= 0) {
            string2 = string2.substring(0, n);
        }
        return JspUtil.encodeToJavaIdentifier(string2, '\uffff');
    }

    public static String encodeToJavaIdentifier(String string, char c) {
        if (!encodeToJavaFlag) {
            return string;
        }
        if (string == null) {
            return null;
        }
        int n = string.length();
        if (n == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (string.charAt(0) != c) {
            stringBuffer.append('_');
        }
        int n2 = 0;
        while (n2 < n) {
            char c2 = string.charAt(n2);
            if (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9') {
                stringBuffer.append(c2);
            } else if (c2 == c) {
                stringBuffer.append(c);
                if (n2 != n - 1) {
                    stringBuffer.append('_');
                }
            } else if (c2 == '_') {
                stringBuffer.append("__");
            } else {
                stringBuffer.append("_" + Integer.toHexString(c2) + "_");
            }
            ++n2;
        }
        return new String(stringBuffer);
    }

    public static String encodeToJavaIdentifier(String string) {
        return JspUtil.encodeToJavaIdentifier(string, '\uffff');
    }

    public static String stripProtocol(String string) {
        int n = string.length();
        if (string == null || n == 0) {
            return "/";
        }
        if (string.charAt(0) != '/') {
            int n2 = string.indexOf("/");
            if (n2 == -1) {
                return string;
            }
            if (n2 < n - 1 && string.charAt(n2 + 1) == '/') {
                ++n2;
            }
            return string.substring(n2);
        }
        return string;
    }

    public static boolean hasTarget(String string) {
        int n = string.lastIndexOf("/");
        int n2 = string.lastIndexOf(".");
        return n2 > 0 && n2 > n;
    }

    public static String addTarget(String string) {
        if (string.charAt(string.length() - 1) == '/') {
            return String.valueOf(string) + DEFAULT_PAGE;
        }
        return String.valueOf(string) + "/" + DEFAULT_PAGE;
    }

    public static String getTarget(String string) {
        int n = 0;
        n = string.indexOf("?");
        if (n != -1) {
            string = string.substring(0, n);
        }
        if ((n = string.lastIndexOf("/")) < 0) {
            return string;
        }
        if (n == string.length() - 1) {
            return DEFAULT_PAGE;
        }
        return string.substring(n + 1);
    }

    public static String stripTarget(String string) {
        return JspUtil.stripTarget(string, '/');
    }

    public static String stripTarget(String string, char c) {
        String string2 = JspUtil.handleDotsInPath(string, c);
        if (string2 == null) {
            throw new IllegalArgumentException(msgs.getString("invalid_dots"));
        }
        string = string2;
        int n = string.lastIndexOf(c);
        if (n <= 0) {
            return String.valueOf(c);
        }
        return string.substring(0, n);
    }

    public static String handleDotsInPath(String string) {
        return JspUtil.handleDotsInPath(string, '/');
    }

    public static String handleDotsInPath(String string, char c) {
        String string2;
        String string3;
        int n = string.indexOf(63);
        if (n == -1) {
            string3 = string;
            string2 = "";
        } else {
            string3 = string.substring(0, n);
            string2 = string.substring(n, string.length());
        }
        char[] cArray = string3.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = cArray.length;
        int n3 = 0;
        while (n3 < n2) {
            if (cArray[n3] == c) {
                if (n3 <= 0 || cArray[n3 - 1] != c) {
                    stringBuffer.append(cArray[n3]);
                }
            } else {
                stringBuffer.append(cArray[n3]);
            }
            ++n3;
        }
        char[] cArray2 = new String(stringBuffer).toCharArray();
        int n4 = 0;
        int n5 = string3.indexOf(c, n4);
        StringBuffer stringBuffer2 = new StringBuffer();
        do {
            if (cArray2[n4] == '.') {
                if (cArray2.length == n4 + 1 || cArray2[n4 + 1] == c) {
                    if ((n4 += 2) > cArray2.length) {
                        n4 = cArray2.length;
                    }
                } else if (cArray2[n4 + 1] == '.' && (cArray2.length == n4 + 2 || cArray2[n4 + 2] == c)) {
                    if (stringBuffer2.length() < 2) {
                        return null;
                    }
                    int n6 = -1;
                    int n7 = stringBuffer2.length() - 2;
                    while (n7 >= 0) {
                        if (stringBuffer2.charAt(n7) == c) {
                            n6 = n7;
                            break;
                        }
                        --n7;
                    }
                    stringBuffer2.setLength(n6 + 1);
                    if ((n4 += 3) > cArray2.length) {
                        n4 = cArray2.length;
                    }
                } else {
                    if (n5 == -1) break;
                    stringBuffer2.append(cArray2, n4, n5 + 1 - n4);
                    n4 = n5 + 1;
                }
            } else {
                if (n5 == -1) break;
                stringBuffer2.append(cArray2, n4, n5 + 1 - n4);
                n4 = n5 + 1;
            }
            n5 = string3.indexOf(c, n4);
        } while (n4 < cArray2.length && n5 < cArray2.length);
        if (n4 < cArray2.length) {
            stringBuffer2.append(cArray2, n4, cArray2.length - n4);
        }
        stringBuffer2.append(string2);
        return new String(stringBuffer2);
    }

    public static String filePathAfterAppPath(String string, String string2) throws IOException {
        string = new File(string).getCanonicalPath();
        string2 = new File(string2).getCanonicalPath();
        return JspUtil.pathAfterAppPath(string, string2, File.separatorChar);
    }

    public static String pathAfterAppPath(String string, String string2, char c) {
        string = JspUtil.handleDotsInPath(string, c);
        string2 = JspUtil.handleDotsInPath(string2, c);
        int n = string2.length();
        if (string2 == null || n == 0) {
            return string;
        }
        int n2 = string.indexOf(string2);
        if (n2 == 0) {
            if (string2.charAt(n - 1) == c) {
                return string.substring(n);
            }
            if (string.length() > n && string.charAt(n) == c) {
                return string.substring(n + 1);
            }
            return string;
        }
        return string;
    }

    public static String replaceTargetExtension(String string, String string2) {
        int n = string.lastIndexOf(".");
        if (n == -1) {
            if (string2.charAt(0) == '.') {
                return String.valueOf(string) + string2;
            }
            return String.valueOf(string) + "." + string2;
        }
        if (string2.charAt(0) == '.') {
            return String.valueOf(string.substring(0, n)) + string2;
        }
        return String.valueOf(string.substring(0, n + 1)) + string2;
    }

    public static String request2AppPath(HttpServletRequest httpServletRequest) throws ServletException {
        String string = null;
        String string2 = JspUtil.getServletPath(httpServletRequest);
        String string3 = JspUtil.getPathInfo(httpServletRequest);
        if (string2 == null && string3 == null) {
            throw new ServletException(msgs.getString("no_app_path"));
        }
        string = string2 == null || string2.length() <= 1 || JspUtil.servletPathContainsServletName(httpServletRequest) ? string3 : (string3 == null || string3.length() <= 1 ? string2 : String.valueOf(string2) + string3);
        int n = string.lastIndexOf("/");
        if (n == -1) {
            throw new ServletException(msgs.getString("no_app_path"));
        }
        if (n != string.length() - 1) {
            string = string.substring(0, n + 1);
        }
        return string;
    }

    public static String getStackTraceStr(Throwable throwable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        return byteArrayOutputStream.toString();
    }

    public static boolean needToSendError(ServletConfig servletConfig) {
        String string = servletConfig.getInitParameter("send_error");
        boolean bl = false;
        if (string != null) {
            bl = Boolean.valueOf(string);
        }
        return bl;
    }

    public static String format(String string, Object[] objectArray) {
        if (objectArray == null) {
            return string;
        }
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] == null) {
                objectArray[n] = "null";
            }
            ++n;
        }
        return MessageFormat.format(string, objectArray);
    }

    public static void setDefaultContentType(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string = null;
        if (httpServletRequest instanceof JspHttpRequest) {
            string = (String)((JspHttpRequest)httpServletRequest).getAttribute(INCLUDED_REQUEST_URI);
        } else {
            try {
                string = (String)httpServletRequest.getAttribute(INCLUDED_REQUEST_URI);
            }
            catch (Exception exception) {}
        }
        if (string == null) {
            httpServletResponse.setContentType("text/html;charset=ISO-8859-1");
        }
    }

    public static String getContextPath(HttpServletRequest httpServletRequest) {
        try {
            return httpServletRequest.getContextPath();
        }
        catch (Throwable throwable) {
            String string = httpServletRequest.getRequestURI().trim();
            String string2 = httpServletRequest.getPathInfo().trim();
            int n = string.indexOf(string2);
            if (n == -1) {
                throw new IllegalArgumentException(JspUtil.format(msgs.getString("no_context_path"), new Object[]{string, string2}));
            }
            return string.substring(0, n);
        }
    }
}

